/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import java.util.List;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class EntityMaidCompassSetting
extends EntityAIBase {
    private final double movementSpeed;
    private EntityMaid entityMaid;
    private int timeCount;
    private ItemKappaCompass.Mode mode;

    public EntityMaidCompassSetting(EntityMaid entityMaid, double speedIn) {
        this.entityMaid = entityMaid;
        this.movementSpeed = speedIn;
        this.mode = entityMaid.getCompassMode();
        this.timeCount = 200;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        return !this.entityMaid.guiOpening && --this.timeCount < 0 && this.entityMaid.isHomeModeEnable() && !this.entityMaid.func_70906_o() && !this.entityMaid.isSleep() && this.entityMaid.getCompassMode() != ItemKappaCompass.Mode.NONE;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        this.timeCount = 200;
        if (this.entityMaid.func_70781_l()) {
            this.timeCount = 20;
            return;
        }
        this.mode = this.entityMaid.getCompassMode();
        List<BlockPos> posList = this.entityMaid.getCompassPosList(this.mode);
        if (posList.size() <= 0) {
            return;
        }
        switch (this.mode) {
            case SINGLE_POINT: {
                this.singlePointAi(posList);
                break;
            }
            case MULTI_POINT_REENTRY: {
                this.multiPointReentryAi(posList);
                break;
            }
            case MULTI_POINT_CLOSURE: {
                this.multiPointClosureAi(posList);
                break;
            }
            case SET_RANGE: {
                this.setRangeAi();
                break;
            }
        }
    }

    private void setRangeAi() {
        BlockPos home;
        if (!this.entityMaid.func_110173_bK() && !(home = this.entityMaid.func_180486_cf()).equals((Object)BlockPos.field_177992_a)) {
            this.entityMaid.func_70661_as().func_75492_a((double)home.func_177958_n(), (double)home.func_177956_o(), (double)home.func_177952_p(), this.movementSpeed);
        }
    }

    private void multiPointClosureAi(List<BlockPos> posList) {
        int currentIndex = this.entityMaid.getCurrentIndex();
        BlockPos pos = posList.get(currentIndex);
        if (this.entityMaid.func_180425_c().func_177951_i((Vec3i)pos) <= 1.2) {
            int nextIndex = (currentIndex + 1) % posList.size();
            BlockPos nextPos = posList.get(nextIndex);
            if (this.entityMaid.func_70661_as().func_75492_a((double)nextPos.func_177958_n(), (double)nextPos.func_177956_o(), (double)nextPos.func_177952_p(), this.movementSpeed)) {
                this.entityMaid.setCurrentIndex(nextIndex);
                this.timeCount = 20;
            } else {
                this.timeCount = 200;
            }
        } else {
            this.timeCount = this.entityMaid.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.movementSpeed) ? 20 : 200;
        }
    }

    private void multiPointReentryAi(List<BlockPos> posList) {
        int currentIndex = this.entityMaid.getCurrentIndex();
        boolean descending = this.entityMaid.isDescending();
        BlockPos pos = posList.get(currentIndex);
        if (this.entityMaid.func_180425_c().func_177951_i((Vec3i)pos) <= 1.2) {
            if (currentIndex == 0) {
                descending = false;
            }
            if (currentIndex == posList.size() - 1) {
                descending = true;
            }
            int next = descending ? -1 : 1;
            int nextIndex = (currentIndex + next) % posList.size();
            BlockPos nextPos = posList.get(nextIndex);
            if (this.entityMaid.func_70661_as().func_75492_a((double)nextPos.func_177958_n(), (double)nextPos.func_177956_o(), (double)nextPos.func_177952_p(), this.movementSpeed)) {
                this.entityMaid.setCurrentIndex(nextIndex);
                this.entityMaid.setDescending(descending);
                this.timeCount = 20;
            } else {
                this.timeCount = 200;
            }
        } else {
            this.timeCount = this.entityMaid.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.movementSpeed) ? 20 : 200;
        }
    }

    private void singlePointAi(List<BlockPos> posList) {
        BlockPos pos = posList.get(0);
        double distance = this.entityMaid.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (8.0 < distance && distance < 16.0) {
            this.entityMaid.func_70661_as().func_75499_g();
            this.entityMaid.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.movementSpeed);
        } else if (distance >= 16.0) {
            this.entityMaid.func_184595_k(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        this.timeCount = 100;
    }
}

