/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.api.task.FarmHandler;
import com.github.tartaricacid.touhoulittlemaid.util.ItemFindUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class EntityMaidFarm
extends EntityAIMoveToBlock {
    private final AbstractEntityMaid maid;
    private NonNullList<ItemStack> seeds = NonNullList.func_191196_a();
    private List<FarmHandler> handlers;
    private FarmHandler activeHandler;
    private ItemStack activeSeed = ItemStack.field_190927_a;
    private ResourceLocation mode;
    private TASK currentTask;

    public EntityMaidFarm(AbstractEntityMaid entityMaid, double speedIn, ResourceLocation mode) {
        super((EntityCreature)entityMaid, speedIn, 16);
        this.maid = entityMaid;
        this.mode = mode;
    }

    public boolean func_75250_a() {
        if (this.maid.func_70906_o() || this.maid.isSleep()) {
            return false;
        }
        if (--this.field_179496_a > 0) {
            return false;
        }
        this.field_179496_a = 10 + this.maid.func_70681_au().nextInt(60);
        this.currentTask = TASK.NONE;
        this.handlers = LittleMaidAPI.getFarmHandlers().stream().filter(h -> h.canExecute(this.maid) && h.getName().equals((Object)this.mode)).collect(Collectors.toList());
        if (this.handlers.isEmpty()) {
            return false;
        }
        this.seeds.clear();
        IItemHandlerModifiable inv = this.maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.handlers.stream().anyMatch(h -> h.isSeed(stack))) continue;
            this.seeds.add((Object)stack);
        }
        return this.func_179489_g();
    }

    public boolean func_75253_b() {
        return this.activeHandler != null && this.currentTask != TASK.NONE && !this.maid.func_70906_o() && !this.maid.isSleep() && super.func_75253_b();
    }

    public void func_75246_d() {
        if (this.activeHandler == null) {
            return;
        }
        this.tryMoveToDestination(this.activeHandler.getMinDistanceSq(), 40);
        boolean shouldLook = true;
        if (this.func_179487_f()) {
            World world = this.maid.field_70170_p;
            BlockPos pos = this.field_179494_b.func_177984_a();
            IBlockState state = world.func_180495_p(pos);
            if (this.currentTask == TASK.HARVEST && this.activeHandler.canHarvest(this.maid, world, pos, state)) {
                this.harvestLogic(world, pos, state);
            } else if (this.currentTask == TASK.PLANT && this.activeHandler.canPlant(this.maid, world, pos, this.activeSeed)) {
                shouldLook = this.plantLogic(world, pos);
            }
            this.currentTask = TASK.NONE;
            this.field_179496_a = 5;
        }
        if (shouldLook) {
            this.maid.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.maid.func_70646_bf());
        }
    }

    protected boolean func_179488_a(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        boolean taskPlaceIsOkay;
        boolean taskDestroyIsOkay;
        pos = pos.func_177984_a();
        IBlockState stateUp = worldIn.func_180495_p(pos);
        IBlockState stateUp2 = worldIn.func_180495_p(pos.func_177984_a());
        if (!stateUp2.func_177230_c().func_176205_b((IBlockAccess)worldIn, pos.func_177984_a())) {
            return false;
        }
        boolean bl = taskDestroyIsOkay = this.currentTask == TASK.HARVEST || this.currentTask == TASK.NONE;
        if (taskDestroyIsOkay && this.maid.canDestroyBlock(pos)) {
            for (FarmHandler handler : this.handlers) {
                if (!handler.canHarvest(this.maid, worldIn, pos, stateUp) || this.maid.func_70661_as().func_179680_a(pos) == null) continue;
                this.activeHandler = handler;
                this.currentTask = TASK.HARVEST;
                return true;
            }
        }
        boolean bl2 = taskPlaceIsOkay = this.currentTask == TASK.PLANT || this.currentTask == TASK.NONE;
        if (taskPlaceIsOkay && !this.seeds.isEmpty() && this.maid.canPlaceBlock(pos, stateUp)) {
            for (FarmHandler handler : this.handlers) {
                for (ItemStack seed : this.seeds) {
                    if (!handler.isSeed(seed) || !handler.canPlant(this.maid, worldIn, pos, seed) || this.maid.func_70661_as().func_179680_a(pos) == null) continue;
                    this.currentTask = TASK.PLANT;
                    this.activeHandler = handler;
                    this.activeSeed = seed;
                    return true;
                }
            }
        }
        return false;
    }

    private void tryMoveToDestination(double minDistanceSq, int interval) {
        if (this.maid.func_174831_c(this.field_179494_b.func_177984_a()) > Math.sqrt(minDistanceSq)) {
            this.field_179491_g = false;
            ++this.field_179493_e;
            if (this.field_179493_e % interval == 0) {
                this.maid.func_70661_as().func_75492_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, this.field_179492_d);
            }
        } else {
            this.field_179491_g = true;
            --this.field_179493_e;
        }
    }

    private boolean plantLogic(World world, BlockPos pos) {
        boolean shouldLook = false;
        IItemHandlerModifiable itemHandler = this.maid.getAvailableInv(true);
        int slot = ItemFindUtil.findStackSlot((IItemHandler)itemHandler, s -> s == this.activeSeed);
        if (slot >= 0) {
            ItemStack remain = this.activeHandler.plant(this.maid, world, pos, this.activeSeed);
            itemHandler.setStackInSlot(slot, remain);
            this.activeSeed = remain;
            this.maid.func_184609_a(EnumHand.MAIN_HAND);
            shouldLook = true;
        }
        return shouldLook;
    }

    private void harvestLogic(World world, BlockPos pos, IBlockState state) {
        this.activeHandler.harvest(this.maid, world, pos, state);
        this.maid.func_184609_a(EnumHand.MAIN_HAND);
    }

    private static enum TASK {
        PLANT,
        HARVEST,
        NONE;

    }
}

