/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFurnaceGuide;
import com.github.tartaricacid.touhoulittlemaid.util.ItemFindUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EntityMaidFurnace
extends EntityAIMoveToBlock {
    private static final int DISTANCE_SQ = 4;
    private final AbstractEntityMaid maid;

    public EntityMaidFurnace(AbstractEntityMaid entityMaid, float speed) {
        super((EntityCreature)entityMaid, (double)speed, 8);
        this.maid = entityMaid;
    }

    public boolean func_75250_a() {
        if (this.maid.func_70906_o() || this.maid.isSleep() || !this.maid.func_70909_n()) {
            return false;
        }
        if (this.field_179496_a > 0) {
            --this.field_179496_a;
            return false;
        }
        this.field_179496_a = 80 + this.maid.func_70681_au().nextInt(40);
        if (this.maid.func_184614_ca().func_77973_b() == MaidItems.FURNACE_GUIDE) {
            return this.func_179489_g();
        }
        return false;
    }

    public void func_75246_d() {
        TileEntity te;
        if (this.maid.func_174831_c(this.field_179494_b.func_177984_a()) > 4.0) {
            this.field_179491_g = false;
            ++this.field_179493_e;
            if (this.field_179493_e % 40 == 0) {
                this.maid.func_70661_as().func_75492_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, this.field_179492_d);
            }
        } else {
            this.field_179491_g = true;
            --this.field_179493_e;
        }
        if (this.func_179487_f() && (te = this.maid.field_70170_p.func_175625_s(this.field_179494_b)) instanceof TileEntityFurnace) {
            int afterCount;
            int slot;
            int i;
            TileEntityFurnace furnace = (TileEntityFurnace)te;
            IItemHandlerModifiable maidInv = this.maid.getAvailableInv(false);
            ItemStackHandler guideInv = ItemFurnaceGuide.getGuideInv(this.maid.func_184614_ca());
            IItemHandler output = (IItemHandler)furnace.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            IItemHandler fuel = (IItemHandler)furnace.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.WEST);
            IItemHandler input = (IItemHandler)furnace.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            boolean swingHand = false;
            if (output != null) {
                for (i = 0; i < output.getSlots(); ++i) {
                    int afterCount2;
                    int beforeCount;
                    int[] slotIndex = furnace.func_180463_a(EnumFacing.DOWN);
                    if (!furnace.func_180461_b(slotIndex[i], output.getStackInSlot(i), EnumFacing.DOWN) || (beforeCount = output.getStackInSlot(i).func_190916_E()) == (afterCount2 = ItemHandlerHelper.insertItemStacked((IItemHandler)maidInv, (ItemStack)output.getStackInSlot(i).func_77946_l(), (boolean)false).func_190916_E())) continue;
                    ItemStack result = output.extractItem(i, beforeCount - afterCount2, false);
                    swingHand = true;
                    this.getSmeltingXp(result);
                }
            }
            if (fuel != null) {
                for (i = 0; i < fuel.getSlots(); ++i) {
                    for (int j = 8; j < guideInv.getSlots(); ++j) {
                        int beforeCount;
                        ItemStack fuelList = guideInv.getStackInSlot(j);
                        slot = ItemFindUtil.findStackSlot((IItemHandler)maidInv, s -> s.func_185136_b(fuelList));
                        if (slot == -1 || (beforeCount = maidInv.getStackInSlot(slot).func_190916_E()) == (afterCount = ItemHandlerHelper.insertItemStacked((IItemHandler)fuel, (ItemStack)maidInv.getStackInSlot(slot).func_77946_l(), (boolean)false).func_190916_E())) continue;
                        maidInv.extractItem(slot, beforeCount - afterCount, false);
                        swingHand = true;
                    }
                }
            }
            if (input != null) {
                for (i = 0; i < input.getSlots(); ++i) {
                    for (int j = 0; j < 8; ++j) {
                        int beforeCount;
                        ItemStack inputList = guideInv.getStackInSlot(j);
                        slot = ItemFindUtil.findStackSlot((IItemHandler)maidInv, s -> s.func_185136_b(inputList));
                        if (slot == -1 || (beforeCount = maidInv.getStackInSlot(slot).func_190916_E()) == (afterCount = ItemHandlerHelper.insertItemStacked((IItemHandler)input, (ItemStack)maidInv.getStackInSlot(slot).func_77946_l(), (boolean)false).func_190916_E())) continue;
                        maidInv.extractItem(slot, beforeCount - afterCount, false);
                        swingHand = true;
                    }
                }
            }
            if (swingHand) {
                this.maid.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    private void getSmeltingXp(ItemStack result) {
        int removeCount;
        int xp = removeCount = result.func_190916_E();
        float smeltingExperience = FurnaceRecipes.func_77602_a().func_151398_b(result);
        if (smeltingExperience <= 0.0f) {
            xp = 0;
        } else if (smeltingExperience < 1.0f) {
            int ceilXp;
            float actualXp = (float)removeCount * smeltingExperience;
            int floorXp = MathHelper.func_76141_d((float)actualXp);
            if (floorXp < (ceilXp = MathHelper.func_76123_f((float)actualXp)) && Math.random() < (double)(actualXp - (float)floorXp)) {
                ++floorXp;
            }
            xp = floorXp;
        }
        while (xp > 0) {
            int split = EntityXPOrb.func_70527_a((int)xp);
            xp -= split;
            this.maid.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.maid.field_70170_p, this.maid.field_70165_t, this.maid.field_70163_u + 0.5, this.maid.field_70161_v + 0.5, split));
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean func_179488_a(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityFurnace) {
            IBlockState state = worldIn.func_180495_p(pos);
            return state.func_177230_c() == Blocks.field_150460_al || state.func_177230_c() == Blocks.field_150470_am;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.maid.func_70906_o() || this.maid.isSleep()) {
            return false;
        }
        return super.func_75253_b() && this.maid.func_184614_ca().func_77973_b() == MaidItems.FURNACE_GUIDE;
    }
}

