/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemHammer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class EntityMaidHammer
extends EntityAIBase {
    private static final int DISTANCE_SQ = 4;
    private final AbstractEntityMaid maid;
    private final float speed;
    private int countTime;

    public EntityMaidHammer(AbstractEntityMaid entityMaid, float speed) {
        this.maid = entityMaid;
        this.speed = speed;
        this.countTime = 10;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.maid.func_70906_o() || this.maid.isSleep() || !this.maid.func_70909_n()) {
            return false;
        }
        if (this.countTime > 0) {
            --this.countTime;
            return false;
        }
        this.countTime = 10;
        return this.hasHammerWithPos(this.maid);
    }

    public void func_75246_d() {
        BlockPos pos = ItemHammer.getStoreBlockPos(this.maid.func_184592_cb());
        if (pos == null) {
            return;
        }
        if (this.maid.field_70170_p.func_175667_e(pos) && !this.maid.field_70170_p.func_175623_d(pos) && this.maid.func_180485_d(pos)) {
            if (this.maid.func_174831_c(pos) <= 4.0) {
                if (this.canHarvestBlock(this.maid, (IBlockAccess)this.maid.field_70170_p, pos)) {
                    this.maid.destroyBlock(pos, true);
                    this.maid.func_184614_ca().func_77972_a(1, (EntityLivingBase)this.maid);
                    this.maid.func_184609_a(EnumHand.MAIN_HAND);
                }
            } else if (this.maid.func_70661_as().func_179680_a(pos) != null) {
                this.maid.func_70671_ap().func_75650_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0f, (float)this.maid.func_70646_bf());
                this.maid.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)this.speed);
            }
        }
    }

    public void func_75251_c() {
        this.maid.func_70661_as().func_75499_g();
    }

    public boolean func_75253_b() {
        if (this.maid.func_70906_o() || this.maid.isSleep()) {
            return false;
        }
        BlockPos pos = ItemHammer.getStoreBlockPos(this.maid.func_184592_cb());
        if (pos == null) {
            return false;
        }
        return this.maid.field_70170_p.func_175667_e(pos) && this.maid.func_180485_d(pos);
    }

    private boolean hasHammerWithPos(AbstractEntityMaid maid) {
        ItemStack stack = maid.func_184592_cb();
        if (stack.func_77973_b() != MaidItems.HAMMER) {
            return false;
        }
        return ItemHammer.getStoreBlockPos(stack) != null;
    }

    private boolean canHarvestBlock(@Nonnull AbstractEntityMaid maid, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_177230_c().func_176221_a(state, world, pos)).func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = maid.func_184614_ca();
        Block block = state.func_177230_c();
        String tool = block.getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return false;
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, null, state);
        if (toolLevel < 0) {
            return false;
        }
        return toolLevel >= block.getHarvestLevel(state);
    }
}

