/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.util.ItemDropUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractEntityFromItem
extends EntityLivingBase {
    private static final String GAME_RULES_DO_ENTITY_DROPS = "doEntityDrops";

    AbstractEntityFromItem(World worldIn) {
        super(worldIn);
    }

    protected abstract boolean canKillEntity(EntityPlayer var1);

    protected abstract SoundEvent getHitSound();

    protected abstract Item getWithItem();

    protected abstract ItemStack getKilledStack();

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer) {
                return this.applyHitEntityLogic((EntityPlayer)source.func_76346_g());
            }
        }
        return false;
    }

    private boolean applyHitEntityLogic(EntityPlayer player) {
        boolean isPlayerCreativeMode = player.field_71075_bZ.field_75098_d;
        if (player.func_70093_af()) {
            this.func_184226_ay();
            this.func_184185_a(this.getHitSound(), 1.0f, 1.0f);
            if (isPlayerCreativeMode && !this.func_145818_k_()) {
                this.func_70106_y();
            } else if (this.canKillEntity(player)) {
                this.killEntity();
            }
            IItemHandler itemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemDropUtil.dropItemHandlerItems(itemHandler, this.field_70170_p, this.func_174791_d());
        }
        return true;
    }

    private void killEntity() {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b(GAME_RULES_DO_ENTITY_DROPS)) {
            ItemStack itemstack = this.getKilledStack();
            if (this.func_145818_k_()) {
                itemstack.func_151001_c(this.func_95999_t());
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public void func_70653_a(@Nonnull Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getKilledStack();
    }

    public boolean func_190631_cK() {
        return false;
    }

    protected void applyEntityCrammingDamage(List<Entity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        int maxEntityCramming = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
        if (maxEntityCramming > 0 && entities.size() > maxEntityCramming - 1 && this.field_70146_Z.nextInt(4) == 0) {
            int collidableEntities = 0;
            for (Entity entity : entities) {
                if (!entity.func_184218_aH()) continue;
                ++collidableEntities;
            }
            if (collidableEntities > maxEntityCramming) {
                this.func_70097_a(DamageSource.field_191291_g, 6.0f);
            }
        }
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(@Nonnull EntityEquipmentSlot slotIn, @Nonnull ItemStack stack) {
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    @Nonnull
    public EnumHandSide func_184591_cq() {
        return EnumHandSide.LEFT;
    }
}

