/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBox
extends Entity {
    public static final int FIRST_STAGE = 64;
    public static final int SECOND_STAGE = 60;
    public static final int THIRD_STAGE = 0;
    public static final int MAX_TEXTURE_SIZE = 7;
    private static final String STAGE_TAG = "OpenStage";
    private static final String TEXTURE_TAG = "TextureIndex";
    private static final DataParameter<Integer> OPEN_STAGE = EntityDataManager.func_187226_a(EntityBox.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TEXTURE_INDEX = EntityDataManager.func_187226_a(EntityBox.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBox(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 2.0f);
    }

    public void func_70030_z() {
        if (!this.func_189652_ae() && !this.field_70122_E) {
            this.field_70181_x = -0.04;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        super.func_70030_z();
        int stage = this.getOpenStage();
        this.stageChange(stage);
        for (Entity riding : this.func_184188_bt()) {
            if (!(riding instanceof EntityTameable)) continue;
            this.applyInvisibilityEffect((EntityTameable)riding, stage);
        }
        this.collideWithNearbyEntities();
    }

    private void stageChange(int stage) {
        if (stage != 64 && stage != 60 && stage != 0) {
            this.setOpenStage(stage - 1);
        }
        if (stage < 0) {
            this.func_70106_y();
            this.onDeath();
        }
    }

    private void applyInvisibilityEffect(EntityTameable tameable, int stage) {
        if (stage > 64) {
            tameable.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 2, 1, false, false));
        }
    }

    private void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186664_h(1.0));
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            boolean notRiddenAndRiding;
            if (entity.func_184196_w((Entity)this)) continue;
            boolean bl = notRiddenAndRiding = !entity.func_184207_aI() && !entity.func_184218_aH();
            if (this.field_70170_p.field_72995_K || !notRiddenAndRiding || !(entity instanceof EntityTameable)) continue;
            if (((EntityTameable)entity).func_70906_o()) {
                return;
            }
            entity.func_184220_m((Entity)this);
        }
    }

    private void onDeath() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_145779_a(Items.field_151121_aF, 2 + this.field_70146_Z.nextInt(3));
        }
    }

    public double func_70042_X() {
        return 0.0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OPEN_STAGE, (Object)64);
        this.field_70180_af.func_187214_a(TEXTURE_INDEX, (Object)1);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.getOpenStage() == 64) {
            this.setOpenStage(63);
            this.func_184185_a(MaidSoundEvent.BOX_OPEN, 3.0f, 1.0f);
            return true;
        }
        if (this.getOpenStage() == 60) {
            this.setOpenStage(59);
            this.func_184185_a(MaidSoundEvent.BOX_OPEN, 3.0f, 1.0f);
            return true;
        }
        if (this.getOpenStage() == 0) {
            this.setOpenStage(-1);
            this.func_184185_a(MaidSoundEvent.BOX_OPEN, 3.0f, 2.0f);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public int getOpenStage() {
        return (Integer)this.field_70180_af.func_187225_a(OPEN_STAGE);
    }

    public void setOpenStage(int stage) {
        this.field_70180_af.func_187227_b(OPEN_STAGE, (Object)MathHelper.func_76125_a((int)stage, (int)-1, (int)64));
    }

    public int getTextureIndex() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.field_70180_af.func_187227_b(TEXTURE_INDEX, (Object)MathHelper.func_76125_a((int)index, (int)1, (int)7));
    }

    public void setRandomTexture() {
        this.setTextureIndex(1 + this.field_70146_Z.nextInt(7));
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        if (compound.func_74764_b(STAGE_TAG)) {
            this.setOpenStage(compound.func_74762_e(STAGE_TAG));
        }
        if (compound.func_74764_b(TEXTURE_TAG)) {
            this.setTextureIndex(compound.func_74762_e(TEXTURE_TAG));
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74768_a(STAGE_TAG, this.getOpenStage());
        compound.func_74768_a(TEXTURE_TAG, this.getTextureIndex());
    }
}

