/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityChair
extends AbstractEntityFromItem {
    private static final DataParameter<String> MODEL_ID = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> MOUNTED_HEIGHT = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> TAMEABLE_CAN_RIDE = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean isDebugFloorOpen = false;
    public boolean isDebugCharacterOpen = false;

    public EntityChair(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.875f, 0.5f);
    }

    public EntityChair(World worldIn, double x, double y, double z, float yaw) {
        this(worldIn);
        this.func_70012_b(x, y, z, yaw, 0.0f);
    }

    @Override
    protected boolean canKillEntity(EntityPlayer player) {
        return !GeneralConfig.MISC_CONFIG.chairCannotBeDestroied || player.func_184812_l_();
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.field_187546_ae;
    }

    @Override
    protected Item getWithItem() {
        return MaidItems.CHAIR;
    }

    @Override
    protected ItemStack getKilledStack() {
        ItemStack itemstack = new ItemStack(this.getWithItem());
        return ItemChair.setAllTagData(itemstack, this.getModelId(), this.getMountedHeight(), this.isTameableCanRide(), this.func_189652_ae());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MODEL_ID, (Object)"touhou_little_maid:cushion");
        this.field_70180_af.func_187214_a(MOUNTED_HEIGHT, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TAMEABLE_CAN_RIDE, (Object)true);
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.0, 0.5, 0.0));
        if (list.isEmpty()) {
            return;
        }
        this.applyEntityCrammingDamage(list);
        for (Entity entity : list) {
            boolean notRiddenAndRiding;
            if (entity.func_184196_w((Entity)this)) continue;
            boolean bl = notRiddenAndRiding = !entity.func_184207_aI() && !entity.func_184218_aH();
            if (this.field_70170_p.field_72995_K || !notRiddenAndRiding || !(entity instanceof EntityTameable) || !this.isTameableCanRide()) continue;
            if (((EntityTameable)entity).func_70906_o()) {
                return;
            }
            if (entity instanceof EntityMaid && !((EntityMaid)entity).isCanRiding()) {
                return;
            }
            entity.func_184220_m((Entity)this);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    @SideOnly(value=Side.SERVER)
    public boolean func_70067_L() {
        return false;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
                return true;
            }
            if (this.field_70170_p.field_72995_K) {
                player.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.CHAIR.getId(), this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() || player.func_184218_aH())) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger) && passenger instanceof EntityLivingBase) {
            this.field_70761_aq = ((EntityLivingBase)passenger).field_70761_aq;
        }
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (this.field_70170_p.field_72995_K && CustomResourcesLoader.CHAIR_MODEL.getInfo(this.getModelId()).isPresent()) {
            String name = CustomResourcesLoader.CHAIR_MODEL.getInfo(this.getModelId()).get().getName();
            return ParseI18n.parse(name);
        }
        return super.func_70005_c_();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        EntityModelJson modelJson = CustomResourcesLoader.CHAIR_MODEL.getModel(this.getModelId()).orElse(null);
        if (modelJson == null) {
            return super.func_184177_bl();
        }
        return modelJson.renderBoundingBox.func_191194_a(this.func_174791_d());
    }

    public double func_70042_X() {
        return this.getMountedHeight();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(NBT.MODEL_ID.getName())) {
            this.setModelId(compound.func_74779_i(NBT.MODEL_ID.getName()));
        }
        if (compound.func_74764_b(NBT.MOUNTED_HEIGHT.getName())) {
            this.setMountedHeight(compound.func_74760_g(NBT.MOUNTED_HEIGHT.getName()));
        }
        if (compound.func_74764_b(NBT.TAMEABLE_CAN_RIDE.getName())) {
            this.setTameableCanRide(compound.func_74767_n(NBT.TAMEABLE_CAN_RIDE.getName()));
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a(NBT.MODEL_ID.getName(), this.getModelId());
        compound.func_74776_a(NBT.MOUNTED_HEIGHT.getName(), this.getMountedHeight());
        compound.func_74757_a(NBT.TAMEABLE_CAN_RIDE.getName(), this.isTameableCanRide());
    }

    public String getModelId() {
        return (String)this.field_70180_af.func_187225_a(MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.field_70180_af.func_187227_b(MODEL_ID, (Object)modelId);
    }

    public float getMountedHeight() {
        return ((Float)this.field_70180_af.func_187225_a(MOUNTED_HEIGHT)).floatValue();
    }

    public void setMountedHeight(float height) {
        height = MathHelper.func_76131_a((float)height, (float)-0.5f, (float)2.5f);
        this.field_70180_af.func_187227_b(MOUNTED_HEIGHT, (Object)Float.valueOf(height));
    }

    public boolean isTameableCanRide() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMEABLE_CAN_RIDE);
    }

    public void setTameableCanRide(boolean canRide) {
        this.field_70180_af.func_187227_b(TAMEABLE_CAN_RIDE, (Object)canRide);
    }

    public boolean hasPassenger() {
        return !this.func_184188_bt().isEmpty();
    }

    public float getPassengerYaw() {
        if (!this.func_184188_bt().isEmpty()) {
            return ((Entity)this.func_184188_bt().get((int)0)).field_70177_z;
        }
        return 0.0f;
    }

    public float getYaw() {
        return this.field_70177_z;
    }

    public float getPassengerPitch() {
        if (!this.func_184188_bt().isEmpty()) {
            return ((Entity)this.func_184188_bt().get((int)0)).field_70125_A;
        }
        return 0.0f;
    }

    public int getDim() {
        return this.field_71093_bK;
    }

    static enum NBT {
        MODEL_ID("ModelId"),
        MOUNTED_HEIGHT("MountedHeight"),
        TAMEABLE_CAN_RIDE("TameableCanRide");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

