/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IEntityRidingMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityMaidVehicle
extends AbstractEntityFromItem
implements IEntityRidingMaid {
    private static final String MODEL_ID_TAG = "ModelIdTag";
    private static final DataParameter<Integer> MODEL_ID = EntityDataManager.func_187226_a(EntityMaidVehicle.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMaidVehicle(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
    }

    @Override
    protected boolean canKillEntity(EntityPlayer player) {
        return true;
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.field_187546_ae;
    }

    @Override
    protected Item getWithItem() {
        return MaidItems.MAID_VEHICLE;
    }

    @Override
    protected ItemStack getKilledStack() {
        return new ItemStack(this.getWithItem(), 1, this.getModelId());
    }

    @Override
    public boolean canRiding(AbstractEntityMaid maid) {
        return maid.isCanHoldVehicle();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MODEL_ID, (Object)0);
    }

    public double func_70042_X() {
        return Type.values()[this.getModelId()].height;
    }

    public float[] getMaidHandRotation(EnumHand hand) {
        Type model = Type.values()[this.getModelId()];
        return hand == EnumHand.MAIN_HAND ? model.rotationRight : model.rotationLeft;
    }

    @Override
    public void updatePassenger(AbstractEntityMaid maid) {
        this.field_70759_as = maid.field_70759_as;
        this.field_70125_A = maid.field_70125_A;
        this.field_70177_z = maid.field_70177_z;
        this.field_70761_aq = maid.field_70761_aq;
        double[] location = Type.values()[this.getModelId()].location;
        Vec3d vec3d = maid.func_174791_d().func_178787_e(new Vec3d(location[0], location[1], location[2]).func_178785_b(maid.field_70761_aq * ((float)(-Math.PI) / 180)));
        this.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151057_cb) {
            return false;
        }
        if (!(player.func_70093_af() || this.field_70170_p.field_72995_K || this.func_184207_aI())) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.0, 0.5, 0.0));
        if (list.isEmpty()) {
            return;
        }
        this.applyEntityCrammingDamage(list);
        for (Entity entity : list) {
            if (entity.func_184196_w((Entity)this)) continue;
            boolean notRiddenAndRiding = !entity.func_184207_aI() && !entity.func_184218_aH();
            boolean isMaidControl = this.func_184187_bx() instanceof AbstractEntityMaid;
            if (this.field_70170_p.field_72995_K || !notRiddenAndRiding || !isMaidControl || !(entity instanceof EntityTameable)) continue;
            if (((EntityTameable)entity).func_70906_o()) {
                return;
            }
            entity.func_184220_m((Entity)this);
        }
    }

    protected boolean func_184228_n(@Nonnull Entity passage) {
        return super.func_184228_n(passage) && this.func_184188_bt().isEmpty() && !passage.func_184207_aI() && !passage.func_184218_aH();
    }

    public void func_110145_l(Entity entityIn) {
        if (!(entityIn instanceof EntityMaid)) {
            super.func_110145_l(entityIn);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(MODEL_ID_TAG, this.getModelId());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setModelId(compound.func_74762_e(MODEL_ID_TAG));
    }

    public int getModelId() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(MODEL_ID)), (int)0, (int)(Type.values().length - 1));
    }

    public void setModelId(int id) {
        this.field_70180_af.func_187227_b(MODEL_ID, (Object)MathHelper.func_76125_a((int)id, (int)0, (int)(Type.values().length - 1)));
    }

    public static enum Type {
        CAT_CART(new float[]{-1.2f, 0.0f, -0.395f}, new float[]{-1.2f, 0.0f, 0.395f}, new double[]{0.0, 0.0, 1.2}, 0.125),
        WHEEL_CHAIR(new float[]{-1.4f, 0.0f, -0.05f}, new float[]{-1.4f, 0.0f, 0.05f}, new double[]{0.0, 0.0, 1.1}, 0.3125),
        RICKSHAW(new float[]{-1.4f, 0.0f, -0.05f}, new float[]{-1.4f, 0.0f, 0.05f}, new double[]{0.0, 0.0, -1.9}, 0.5625);

        float[] rotationLeft;
        float[] rotationRight;
        double[] location;
        double height;

        private Type(float[] rotationLeft, float[] rotationRight, double[] location, double height) {
            this.rotationLeft = rotationLeft;
            this.rotationRight = rotationRight;
            this.location = location;
            this.height = height;
        }

        public static Type getTypeByNum(int num) {
            return Type.values()[num];
        }
    }
}

