/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.item.PortableAudioGui;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityTrolley;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.PortableAudioMessageToClient;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPortableAudio
extends AbstractEntityTrolley {
    private static final String PLAYING_TAG_NAME = "IsSongPlaying";
    private static final String SONG_ID_TAG_NAME = "SongId";
    private static final DataParameter<Boolean> PLAYING = EntityDataManager.func_187226_a(EntityPortableAudio.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> SONG_ID = EntityDataManager.func_187226_a(EntityPortableAudio.class, (DataSerializer)DataSerializers.field_187194_d);
    private List<MusicListData> musicListData = Lists.newArrayList();
    private int index = -1;
    private int nextTime = 0;

    public EntityPortableAudio(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.4f);
    }

    public EntityPortableAudio(World worldIn, double x, double y, double z, float yaw) {
        this(worldIn);
        this.func_70012_b(x, y, z, yaw, 0.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.musicListData.size() != 0) {
            --this.nextTime;
            if (this.nextTime < -40) {
                this.setPlaying(false);
            }
            if (this.nextTime < -50) {
                if (this.index >= this.musicListData.size()) {
                    this.index = 0;
                }
                this.nextTime = this.musicListData.get(this.index).nextTime;
                long nextId = this.musicListData.get(this.index).musicId;
                this.setPlaying(true);
                this.setSongId(nextId);
                PortableAudioMessageToClient msg = new PortableAudioMessageToClient(this.func_145782_y(), nextId);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 96.0);
                CommonProxy.INSTANCE.sendToAllAround((IMessage)msg, point);
                ++this.index;
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYING, (Object)false);
        this.field_70180_af.func_187214_a(SONG_ID, (Object)"0");
    }

    @Override
    protected boolean canKillEntity(EntityPlayer player) {
        return true;
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.field_187550_ag;
    }

    @Override
    protected Item getWithItem() {
        return MaidItems.PORTABLE_AUDIO;
    }

    @Override
    protected ItemStack getKilledStack() {
        return new ItemStack(MaidItems.PORTABLE_AUDIO);
    }

    @Override
    public void updatePassenger(AbstractEntityMaid maid) {
        if (maid.func_184196_w((Entity)this)) {
            this.field_70759_as = maid.field_70759_as;
            this.field_70125_A = maid.field_70125_A;
            this.field_70177_z = maid.field_70177_z;
            this.field_70761_aq = maid.field_70761_aq;
            Vec3d vec3d = maid.func_174791_d().func_178787_e(new Vec3d(0.3, 0.5625, -0.1).func_178785_b(maid.field_70761_aq * ((float)(-Math.PI) / 180)));
            this.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new PortableAudioGui(this));
            return true;
        }
        return false;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPlaying(compound.func_74767_n(PLAYING_TAG_NAME));
        this.setSongId(compound.func_74762_e(SONG_ID_TAG_NAME));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(PLAYING_TAG_NAME, this.isPlaying());
        compound.func_74772_a(SONG_ID_TAG_NAME, this.getSongId());
    }

    public boolean isPlaying() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAYING);
    }

    public void setPlaying(boolean playing) {
        this.field_70180_af.func_187227_b(PLAYING, (Object)playing);
    }

    public long getSongId() {
        return Long.parseUnsignedLong((String)this.field_70180_af.func_187225_a(SONG_ID));
    }

    public void setSongId(long songId) {
        this.field_70180_af.func_187227_b(SONG_ID, (Object)String.valueOf(songId));
    }

    public void clearAllMusicListData() {
        this.musicListData.clear();
        this.index = 0;
        this.nextTime = 0;
    }

    public void setMusicListData(List<MusicListData> musicList) {
        this.musicListData = musicList;
    }

    public void setMusicIndex(int index) {
        this.index = index;
    }

    public static class MusicListData {
        private long musicId;
        private int nextTime;

        public MusicListData(long musicId, int nextTime) {
            this.musicId = musicId;
            this.nextTime = nextTime;
        }

        public long getMusicId() {
            return this.musicId;
        }

        public int getNextTime() {
            return this.nextTime;
        }
    }
}

