/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityTrolley;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.TrolleyAudioSoundMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntityTrolleyAudio
extends AbstractEntityTrolley {
    private static final String RECORD_ITEM = "RecordItem";
    private static final DataParameter<Boolean> STOP_PLAY = EntityDataManager.func_187226_a(EntityTrolleyAudio.class, (DataSerializer)DataSerializers.field_187198_h);
    private final ItemStackHandler recordInv = new ItemStackHandler(){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemRecord;
        }
    };

    public EntityTrolleyAudio(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(0.8f, 0.8f);
    }

    @Override
    protected boolean canKillEntity(EntityPlayer player) {
        return true;
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.field_187546_ae;
    }

    @Override
    protected Item getWithItem() {
        return MaidItems.TROLLEY_AUDIO;
    }

    @Override
    protected ItemStack getKilledStack() {
        return new ItemStack(this.getWithItem());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STOP_PLAY, (Object)true);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.insertRecord(player, this.field_70170_p, player.func_184586_b(hand));
        }
        return true;
    }

    private void insertRecord(EntityPlayer player, World world, ItemStack stack) {
        if (!this.recordInv.getStackInSlot(0).func_190926_b()) {
            this.func_70099_a(this.recordInv.getStackInSlot(0), 0.6f);
            this.recordInv.setStackInSlot(0, ItemStack.field_190927_a);
            this.setStop(true);
        } else if (stack.func_77973_b() instanceof ItemRecord) {
            ItemRecord record = (ItemRecord)stack.func_77973_b();
            this.recordInv.setStackInSlot(0, stack.func_77946_l());
            this.setStop(false);
            if (record.getRegistryName() != null) {
                CommonProxy.INSTANCE.sendToDimension((IMessage)new TrolleyAudioSoundMessage(record.field_185077_c, record.getRegistryName(), this), world.field_73011_w.getDimension());
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
    }

    public boolean isStop() {
        return (Boolean)this.field_70180_af.func_187225_a(STOP_PLAY);
    }

    private void setStop(boolean isStop) {
        this.field_70180_af.func_187227_b(STOP_PLAY, (Object)isStop);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a(RECORD_ITEM, (NBTBase)this.recordInv.serializeNBT());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(RECORD_ITEM, 10)) {
            this.recordInv.deserializeNBT(compound.func_74775_l(RECORD_ITEM));
        }
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.recordInv);
        }
        return (T)super.getCapability(capability, facing);
    }
}

