/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IEntityRidingMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.api.MaidInventory;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidPlaySoundEvent;
import com.github.tartaricacid.touhoulittlemaid.api.util.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGarageKit;
import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBed;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumSerializer;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidLookIdle;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidAvoidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidBeg;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidCompassSetting;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidFindBed;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidFindJoyBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidFollowOwner;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidOpenDoor;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidPanic;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidPickup;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidWanderAvoidWater;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidWatchClosest;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidWatchClosest2;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.MaidNodeProcessor;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMaidJoy;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMarisaBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityRinnosuke;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaidPredicate;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability.EventType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability.FavorabilityEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability.JoyType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability.Level;
import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.inventory.MaidHandsItemHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.MaidInventoryItemHandler;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.UpdateMaidSleepYawMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.util.ItemDropUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;

public class EntityMaid
extends AbstractEntityMaid {
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PICKUP = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> TASK = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> EXP = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HOME = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARM_RISE = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> MODEL_ID = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> STRUCK_BY_LIGHTNING = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> SASIMONO_CRC32 = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> SHOW_SASIMONO = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FAVORABILITY = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SHOW_HELMET = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BACKPACK_LEVEL = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COMPASS_MODE = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEP = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int TASK_PRIORITY = 5;
    private static final float INFINITY_LEASHED_DISTANCE = -1.0f;
    private static int PICKUP_SOUND_COUNT = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
    private static int PLAYER_HURT_SOUND_COUNT = GeneralConfig.MAID_CONFIG.maidHurtSoundInterval;
    private final CooldownTracker cooldownTracker = new CooldownTracker();
    private final EntityArmorInvWrapper armorInvWrapper = new EntityArmorInvWrapper((EntityLivingBase)this);
    private final EntityHandsInvWrapper handsInvWrapper = new MaidHandsItemHandler((EntityLivingBase)this);
    private final ItemStackHandler mainInv = new MaidInventoryItemHandler(15);
    private final ItemStackHandler smallBackpackInv = new MaidInventoryItemHandler(10);
    private final ItemStackHandler middleBackpackInv = new MaidInventoryItemHandler(10);
    private final ItemStackHandler bigBackpackInv = new MaidInventoryItemHandler(10);
    private final BaubleItemHandler baubleInv = new BaubleItemHandler(8);
    public boolean guiOpening;
    public boolean isDebugFloorOpen = false;
    public boolean isDebugBroomShow = false;
    @Nonnull
    private IMaidTask task = LittleMaidAPI.getIdleTask();
    @Nullable
    private EntityAIBase taskAI;
    private List<BlockPos> compassPosList = Lists.newArrayList();
    private int currentIndex = 0;
    private boolean descending = false;
    private boolean canHoldTrolley = true;
    private boolean canHoldVehicle = true;
    private boolean canRidingBroom = true;
    private boolean canRiding = true;
    private BlockPos leashedPosition = BlockPos.field_177992_a;
    private float maximumLeashedDistance = -1.0f;
    private Map<String, Integer> joyTickData = Maps.newHashMap();

    public EntityMaid(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.5f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityMaidFindBed(this, 0.8f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityMaidPanic(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new EntityMaidAvoidEntity<EntityRinnosuke>((EntityCreature)this, EntityRinnosuke.class, 3.0f, 0.8, 0.9));
        this.field_70714_bg.func_75776_a(3, new EntityMaidAvoidEntity<EntityFairy>((EntityCreature)this, EntityFairy.class, 3.0f, 0.8, 0.9));
        this.field_70714_bg.func_75776_a(3, new EntityMaidAvoidEntity<EntityCreeper>((EntityCreature)this, EntityCreeper.class, 6.0f, 0.8, 0.9));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityMaidCompassSetting(this, 0.6f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityMaidBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityMaidOpenDoor(this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityMaidFindJoyBlock(this, 0.8f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityMaidPickup(this, 0.8f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityMaidFollowOwner(this, 0.8f, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityMaidWatchClosest2(this, EntityPlayer.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityMaidWatchClosest(this, EntityMaid.class, 4.0f, 0.2f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityMaidWatchClosest(this, EntityWolf.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityMaidWatchClosest(this, EntityOcelot.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityMaidWatchClosest(this, EntityParrot.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityMaidLookIdle(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityMaidWanderAvoidWater(this, 0.5));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEGGING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(PICKUP, (Object)Boolean.TRUE);
        this.field_70180_af.func_187214_a(TASK, (Object)TaskIdle.UID.toString());
        this.field_70180_af.func_187214_a(EXP, (Object)0);
        this.field_70180_af.func_187214_a(HOME, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ARM_RISE, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(MODEL_ID, (Object)"touhou_little_maid:hakurei_reimu");
        this.field_70180_af.func_187214_a(STRUCK_BY_LIGHTNING, (Object)false);
        this.field_70180_af.func_187214_a(SASIMONO_CRC32, (Object)String.valueOf(0L));
        this.field_70180_af.func_187214_a(SHOW_SASIMONO, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
        this.field_70180_af.func_187214_a(BACKPACK_LEVEL, (Object)EnumBackPackLevel.EMPTY.getLevel());
        this.field_70180_af.func_187214_a(COMPASS_MODE, (Object)ItemKappaCompass.Mode.NONE.ordinal());
        this.field_70180_af.func_187214_a(SLEEP, (Object)false);
        this.field_70180_af.func_187214_a(FAVORABILITY, (Object)0);
        this.field_70180_af.func_187214_a(SHOW_HELMET, (Object)true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
    }

    public void func_70636_d() {
        this.baubleInv.fireEvent((b, s) -> {
            b.onTick(this, (ItemStack)s);
            return false;
        });
        this.func_82168_bl();
        if (PLAYER_HURT_SOUND_COUNT > 0) {
            --PLAYER_HURT_SOUND_COUNT;
        }
        this.spawnPortalParticle();
        this.randomRestoreHealth();
        super.func_70636_d();
        this.applyEntityRiding();
        this.applyNavigatorAndMoveHelper();
        if (this.isSleep()) {
            this.onMaidSleep();
        }
        if (!this.field_70170_p.field_72995_K) {
            JoyType.updateJoyTick(this, this.joyTickData);
        }
        if (!(this.field_70173_aa % 1000 != 0 || this.field_70170_p.field_72995_K || this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72911_I() || this.getTask().getUid().equals((Object)TaskIdle.UID))) {
            MinecraftForge.EVENT_BUS.post((Event)new FavorabilityEvent(EventType.WORK_NIGHT_OR_THUNDERSTORM, this));
        }
    }

    private void onMaidSleep() {
        if (!this.field_70170_p.field_72995_K) {
            IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
            if (state.func_177230_c() == MaidBlocks.MAID_BED && state.func_177229_b(BlockMaidBed.PART) == BlockMaidBed.EnumPartType.FOOT) {
                if (this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72911_I()) {
                    this.setSleep(false);
                    this.func_174810_b(false);
                    this.func_70606_j(this.func_110138_aP());
                    MinecraftForge.EVENT_BUS.post((Event)new FavorabilityEvent(EventType.WAKE_UP_NATURALLY, this));
                } else {
                    if (!this.func_174814_R()) {
                        this.func_174810_b(true);
                    }
                    if (this.field_70173_aa % 2 == 0) {
                        this.func_70080_a(Math.floor(this.field_70165_t) + 0.5, this.field_70163_u, Math.floor(this.field_70161_v) + 0.5, ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_185119_l(), 0.0f);
                    }
                    if (this.field_70173_aa % 60 == 0) {
                        CommonProxy.INSTANCE.sendToAllAround((IMessage)new UpdateMaidSleepYawMessage(this.func_145782_y(), ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_185119_l()), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
                    }
                }
            } else {
                this.setSleep(false);
                this.func_174810_b(false);
                MinecraftForge.EVENT_BUS.post((Event)new FavorabilityEvent(EventType.WAKE_UP_NOISE, this));
            }
        }
    }

    private void spawnPortalParticle() {
        if (this.field_70170_p.field_72995_K && this.func_190530_aW() && this.func_184753_b() != null) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
    }

    private void randomRestoreHealth() {
        if (this.func_110143_aJ() < this.func_110138_aP() && (double)this.field_70146_Z.nextFloat() < 0.0025) {
            Level level = Level.getLevelByCount(this.getFavorability());
            this.func_70691_i(level.getHealthyValue() / 20.0f);
            this.spawnRestoreHealthParticle(this.field_70146_Z.nextInt(3) + 7);
        }
    }

    private void spawnRestoreHealthParticle(int particleCount) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < particleCount; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * 10.0, d0, d1, d2, new int[0]);
            }
        }
    }

    private void applyNavigatorAndMoveHelper() {
        Entity passenger = this.func_184179_bs();
        boolean isRidingBroom = passenger instanceof EntityMarisaBroom;
        boolean isFlyingNavigator = this.field_70699_by instanceof PathNavigateFlying;
        boolean isFlyHelper = this.field_70765_h instanceof EntityFlyHelper;
        if (!(isRidingBroom || isFlyingNavigator || isFlyHelper)) {
            return;
        }
        if (isRidingBroom && isFlyingNavigator && isFlyHelper) {
            return;
        }
        if (isRidingBroom) {
            this.field_70699_by = this.createNavigatorFlying(this.field_70170_p);
            this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        } else {
            this.field_70699_by = this.createNavigatorGround(this.field_70170_p);
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.func_189654_d(false);
        }
    }

    private void applyEntityRiding() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), entity -> entity instanceof IEntityRidingMaid);
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity2 : list) {
            boolean stateIsForbid;
            if (entity2.func_184196_w((Entity)this)) continue;
            boolean maidNotRiddenAndRiding = !this.func_184207_aI() && !this.func_184218_aH();
            boolean passengerNotRiddenAndRiding = !entity2.func_184207_aI() && !entity2.func_184218_aH();
            boolean bl = stateIsForbid = this.func_70906_o() || this.isSleep() || !this.isCanRiding();
            if (this.field_70170_p.field_72995_K || stateIsForbid || !maidNotRiddenAndRiding || !passengerNotRiddenAndRiding || !(entity2 instanceof IEntityRidingMaid) || !((IEntityRidingMaid)entity2).canRiding(this)) continue;
            entity2.func_184220_m((Entity)this);
        }
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (passenger instanceof IEntityRidingMaid) {
            ((IEntityRidingMaid)passenger).updatePassenger(this);
        } else {
            super.func_184232_k(passenger);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    protected void func_85033_bc() {
        List entityList;
        super.func_85033_bc();
        if (this.isPickup() && this.func_70909_n() && !(entityList = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(0.5, 0.0, 0.5).func_72321_a(-0.5, 0.0, -0.5), EntityMaidPredicate.IS_PICKUP)).isEmpty() && this.func_70089_S()) {
            for (Entity entityPickup : entityList) {
                if (entityPickup instanceof EntityItem) {
                    this.pickupItem((EntityItem)entityPickup, false);
                }
                if (entityPickup instanceof EntityXPOrb) {
                    this.pickupXPOrb((EntityXPOrb)entityPickup);
                }
                if (entityPickup instanceof EntityPowerPoint) {
                    this.pickupPowerPoint((EntityPowerPoint)entityPickup);
                }
                if (!(entityPickup instanceof EntityArrow)) continue;
                this.pickupArrow((EntityArrow)entityPickup, false);
            }
        }
    }

    public boolean pickupItem(EntityItem entityItem, boolean simulate) {
        if (!this.field_70170_p.field_72995_K && entityItem.func_70089_S() && !entityItem.func_174874_s()) {
            ItemStack itemstack = entityItem.func_92059_d();
            if (MaidInventoryItemHandler.isIllegalItem(itemstack)) {
                return false;
            }
            int count = itemstack.func_190916_E();
            if (count == (itemstack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)itemstack, (boolean)simulate)).func_190916_E()) {
                return false;
            }
            if (!simulate) {
                this.func_71001_a((Entity)entityItem, count - itemstack.func_190916_E());
                if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this)) && --PICKUP_SOUND_COUNT == 0) {
                    this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                    PICKUP_SOUND_COUNT = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
                }
                if (itemstack.func_190926_b()) {
                    entityItem.func_70106_y();
                } else {
                    entityItem.func_92058_a(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public void pickupXPOrb(EntityXPOrb entityXPOrb) {
        if (!this.field_70170_p.field_72995_K && entityXPOrb.func_70089_S() && entityXPOrb.field_70532_c == 0) {
            ItemStack itemstack;
            this.func_71001_a((Entity)entityXPOrb, 1);
            if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this)) && --PICKUP_SOUND_COUNT == 0) {
                this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                PICKUP_SOUND_COUNT = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
            }
            if (!(itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)this)).func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(entityXPOrb.field_70530_e * 2, itemstack.func_77952_i());
                entityXPOrb.field_70530_e -= i / 2;
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if (entityXPOrb.field_70530_e > 0) {
                this.addExp(entityXPOrb.field_70530_e);
            }
            entityXPOrb.func_70106_y();
        }
    }

    public void pickupPowerPoint(EntityPowerPoint powerPoint) {
        if (!this.field_70170_p.field_72995_K && powerPoint.func_70089_S() && powerPoint.delayBeforeCanPickup == 0) {
            powerPoint.onPickup((EntityLivingBase)this, 1);
            if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this)) && --PICKUP_SOUND_COUNT == 0) {
                this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                PICKUP_SOUND_COUNT = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
            }
            int xpValue = EntityPowerPoint.transPowerValueToXpValue(powerPoint.powerValue);
            ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)this);
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(xpValue * 2, itemstack.func_77952_i());
                xpValue -= i / 2;
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if (xpValue > 0) {
                this.addExp(xpValue);
            }
            powerPoint.func_70106_y();
        }
    }

    public boolean pickupArrow(EntityArrow arrow, boolean simulate) {
        if (!this.field_70170_p.field_72995_K && arrow.func_70089_S() && arrow.field_70254_i && arrow.field_70249_b <= 0) {
            if (arrow.field_70251_a != EntityArrow.PickupStatus.ALLOWED) {
                return false;
            }
            ItemStack stack = this.getArrowFromEntity(arrow);
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)stack, (boolean)simulate).func_190926_b()) {
                return false;
            }
            if (!simulate) {
                this.func_71001_a((Entity)arrow, 1);
                if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this)) && --PICKUP_SOUND_COUNT == 0) {
                    this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                    PICKUP_SOUND_COUNT = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
                }
                arrow.func_70106_y();
            }
            return true;
        }
        return false;
    }

    private ItemStack getArrowFromEntity(EntityArrow entity) {
        try {
            Method method = ReflectionHelper.findMethod(entity.getClass(), (String)"getArrowStack", (String)"func_184550_j", (Class[])new Class[0]);
            method.setAccessible(true);
            return (ItemStack)method.invoke(ItemStack.class, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return new ItemStack(Items.field_151032_g);
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            return ItemStack.field_190927_a;
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && this.func_152114_e((EntityLivingBase)((EntityPlayer)source.func_76346_g()))) {
            if (this.hasSasimono()) {
                amount = MathHelper.func_76131_a((float)(amount / 5.0f), (float)0.0f, (float)2.0f);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new FavorabilityEvent(EventType.HURT_BY_PLAYER, this));
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return !AbstractEntityFromItem.class.isAssignableFrom(cls) && cls != EntityArmorStand.class && super.func_70686_a(cls);
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        this.task.onRangedAttack(this, target, distanceFactor);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean isInvulnerable;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockBack = 0;
        int fireAspect = 0;
        if (entityIn instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            knockBack += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
            fireAspect += EnchantmentHelper.func_90036_a((EntityLivingBase)this);
        }
        if (isInvulnerable = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            if (knockBack > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)knockBack * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (fireAspect > 0) {
                entityIn.func_70015_d(fireAspect * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                this.attackEntityAsPlayer((EntityPlayer)entityIn);
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
            this.func_184614_ca().func_77972_a(1, (EntityLivingBase)this);
        }
        return isInvulnerable;
    }

    private void attackEntityAsPlayer(EntityPlayer entityplayer) {
        ItemStack itemPlayerHand;
        ItemStack itemMaidHand = this.func_184614_ca();
        ItemStack itemStack = itemPlayerHand = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
        if (!itemMaidHand.func_190926_b() && !itemPlayerHand.func_190926_b() && itemMaidHand.func_77973_b().canDisableShield(itemMaidHand, itemPlayerHand, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemPlayerHand.func_77973_b().isShield(itemPlayerHand, (EntityLivingBase)entityplayer)) {
            float efficiencyModifier = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < efficiencyModifier) {
                entityplayer.func_184811_cZ().func_185145_a(itemPlayerHand.func_77973_b(), 100);
                this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
            }
        }
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        if (!this.isStruckByLightning()) {
            double beforeMaxHealth = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(beforeMaxHealth + 20.0);
            this.setStruckByLightning(true);
        }
    }

    protected void func_70675_k(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (int i = 0; i < this.armorInvWrapper.getSlots(); ++i) {
            ItemStack itemstack = this.armorInvWrapper.getStackInSlot(i);
            if (!(itemstack.func_77973_b() instanceof ItemArmor)) continue;
            itemstack.func_77972_a((int)damage, (EntityLivingBase)this);
        }
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, @Nullable EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            boolean isYourMaid = this.func_70909_n() && this.func_184753_b() != null && this.func_184753_b().equals(player.func_110124_au());
            ItemStack itemstack = player.func_184586_b(hand);
            if (isYourMaid) {
                return MinecraftForge.EVENT_BUS.post((Event)new InteractMaidEvent(player, this, itemstack)) || itemstack.func_111282_a(player, (EntityLivingBase)this, EnumHand.MAIN_HAND) || this.openMaidGui(player);
            }
            return this.tamedMaid(itemstack, player);
        }
        return false;
    }

    private boolean tamedMaid(ItemStack itemstack, EntityPlayer player) {
        Item tamedItem = Item.func_111206_d((String)GeneralConfig.MAID_CONFIG.maidTamedItem) == null ? Items.field_151105_aU : Item.func_111206_d((String)GeneralConfig.MAID_CONFIG.maidTamedItem);
        boolean isReloadTamedCondition = itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_189881_dj);
        boolean isNormalTamedCondition = !this.func_70909_n() && itemstack.func_77973_b() == tamedItem;
        boolean isTamedCondition = isReloadTamedCondition || isNormalTamedCondition;
        MaidNumHandler num = (MaidNumHandler)player.getCapability(MaidNumSerializer.MAID_NUM_CAP, null);
        if (!this.field_70170_p.field_72995_K && isTamedCondition && num != null) {
            if (num.canAdd()) {
                this.func_175505_a(player, itemstack);
                this.func_193101_c(player);
                this.func_70908_e(true);
                this.func_70661_as().func_75499_g();
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.func_184185_a(MaidSoundEvent.MAID_TAMED, 1.0f, 1.0f);
                num.add();
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.owner_maid_num.can_not_add", new Object[]{num.get(), num.getMaxNum()}));
        }
        return false;
    }

    private boolean openMaidGui(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && !this.isSleep()) {
            player.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.MAIN_GUI.MAIN.getId(), this.field_70170_p, this.func_145782_y(), LittleMaidAPI.getTasks().indexOf(this.task), 0);
        }
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70878_b(@Nonnull EntityAnimal otherAnimal) {
        return false;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70729_aU) {
            return;
        }
        if (this.baubleInv.fireEvent((b, s) -> b.onDropsPre(this, (ItemStack)s))) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new FavorabilityEvent(EventType.DEATH, this));
        if (!this.field_70170_p.field_72995_K) {
            IItemHandler itemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemDropUtil.dropItemHandlerItems(itemHandler, this.field_70170_p, this.func_174791_d());
            this.dropGarageKit();
        }
    }

    private void dropGarageKit() {
        this.field_70172_ad = 0;
        this.field_70737_aN = 0;
        this.field_70725_aQ = 0;
        NBTTagCompound entityTag = new NBTTagCompound();
        this.func_70014_b(entityTag);
        entityTag.func_82580_o("ArmorItems");
        entityTag.func_82580_o("HandItems");
        entityTag.func_82580_o(NBT.MAID_INVENTORY.getName());
        entityTag.func_82580_o(NBT.BAUBLE_INVENTORY.getName());
        ItemStack stack = BlockGarageKit.getItemStackWithData("touhou_little_maid:entity.passive.maid", this.getModelId(), entityTag);
        EntityItem entityItem = this.func_70099_a(stack, 0.0f);
        entityItem.func_184224_h(true);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.func_70902_q() instanceof EntityPlayerMP) {
            this.sendPositionMessage(entityItem, (EntityPlayerMP)this.func_70902_q());
        }
    }

    private void sendPositionMessage(EntityItem entityItem, EntityPlayerMP owner) {
        BlockPos pos = entityItem.func_180425_c();
        String coordinate = String.format("[x:%d, y:%d, z:%d, dim:%d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityItem.field_71093_bK);
        TextComponentTranslation start = new TextComponentTranslation("message.touhou_little_maid.maid.death_pos", new Object[0]);
        TextComponentString clickable = new TextComponentString(coordinate);
        Style chatStyle = clickable.func_150256_b();
        if (Loader.isModLoaded((String)"journeymap")) {
            chatStyle.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/jm wpedit " + coordinate));
            TextComponentTranslation hover = new TextComponentTranslation("message.touhou_little_maid.maid.journeymap.name", new Object[0]);
            hover.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            TextComponentTranslation click = new TextComponentTranslation("message.touhou_little_maid.maid.journeymap.hover_message.click", new Object[0]);
            TextComponentTranslation ctrlClick = new TextComponentTranslation("message.touhou_little_maid.maid.journeymap.hover_message.ctrl_click", new Object[0]);
            TextComponentString hover2 = new TextComponentString(click.func_150261_e() + "\n" + ctrlClick.func_150261_e());
            hover2.func_150256_b().func_150238_a(TextFormatting.AQUA);
            hover.func_150257_a((ITextComponent)hover2);
            chatStyle.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hover));
        }
        chatStyle.func_150238_a(TextFormatting.AQUA);
        start.func_150257_a((ITextComponent)clickable);
        owner.func_145747_a((ITextComponent)start);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @Nonnull
    @Deprecated
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String modelId = this.getModelId();
        if (this.field_70170_p.field_72995_K) {
            if (CustomResourcesLoader.MAID_MODEL.getInfo(modelId).isPresent()) {
                return ParseI18n.parse(CustomResourcesLoader.MAID_MODEL.getInfo(modelId).get().getName());
            }
        } else if (CommonProxy.VANILLA_ID_NAME_MAP.containsKey(modelId)) {
            return CommonProxy.VANILLA_ID_NAME_MAP.get(modelId);
        }
        return super.func_70005_c_();
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer) {
            return this.func_184187_bx().func_70093_af() ? 0.7 : 0.9;
        }
        return super.func_70033_W();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        if (!CommonProxy.VANILLA_ID_NAME_MAP.isEmpty()) {
            String key = (String)CommonProxy.VANILLA_ID_NAME_MAP.keySet().stream().skip(this.field_70146_Z.nextInt(CommonProxy.VANILLA_ID_NAME_MAP.size())).findFirst().get();
            this.setModelId(key);
        }
        return livingData;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(NBT.MAID_INVENTORY.getName())) {
            this.mainInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_INVENTORY.getName()));
        }
        if (compound.func_74764_b(NBT.BAUBLE_INVENTORY.getName())) {
            this.baubleInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.BAUBLE_INVENTORY.getName()));
        }
        if (compound.func_74764_b(NBT.IS_PICKUP.getName())) {
            this.setPickup(compound.func_74767_n(NBT.IS_PICKUP.getName()));
        }
        if (compound.func_74764_b(NBT.MAID_TASK.getName())) {
            this.setTask((IMaidTask)LittleMaidAPI.findTask(new ResourceLocation(compound.func_74779_i(NBT.MAID_TASK.getName()))).or((Object)LittleMaidAPI.getIdleTask()));
        }
        if (compound.func_74764_b(NBT.MAID_EXP.getName())) {
            this.setExp(compound.func_74762_e(NBT.MAID_EXP.getName()));
        }
        if (compound.func_74764_b(NBT.MAID_HOME.getName())) {
            this.setHomeModeEnable(compound.func_74767_n(NBT.MAID_HOME.getName()));
        }
        if (compound.func_74764_b(NBT.MODEL_ID.getName())) {
            this.setModelId(compound.func_74779_i(NBT.MODEL_ID.getName()));
        }
        if (compound.func_74764_b(NBT.STRUCK_BY_LIGHTNING.getName())) {
            this.setStruckByLightning(compound.func_74767_n(NBT.STRUCK_BY_LIGHTNING.getName()));
        }
        if (compound.func_74764_b(NBT.SASIMONO_CRC32.getName())) {
            this.setSasimonoCRC32(compound.func_74763_f(NBT.SASIMONO_CRC32.getName()));
        }
        if (compound.func_74764_b(NBT.SHOW_SASIMONO.getName())) {
            this.setShowSasimono(compound.func_74767_n(NBT.SHOW_SASIMONO.getName()));
        }
        if (compound.func_74764_b(NBT.INVULNERABLE.getName())) {
            this.func_184224_h(compound.func_74767_n(NBT.INVULNERABLE.getName()));
        }
        if (compound.func_74764_b(NBT.BACKPACK_LEVEL.getName())) {
            this.setBackpackLevel(EnumBackPackLevel.getEnumLevelByNum(compound.func_74762_e(NBT.BACKPACK_LEVEL.getName())));
        }
        if (compound.func_74764_b(NBT.MAID_SMALL_BACKPACK.getName())) {
            this.smallBackpackInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_SMALL_BACKPACK.getName()));
        }
        if (compound.func_74764_b(NBT.MAID_MIDDLE_BACKPACK.getName())) {
            this.middleBackpackInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_MIDDLE_BACKPACK.getName()));
        }
        if (compound.func_74764_b(NBT.MAID_BIG_BACKPACK.getName())) {
            this.bigBackpackInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_BIG_BACKPACK.getName()));
        }
        if (compound.func_74764_b(NBT.COMPASS_MODE.getName())) {
            this.setCompassMode(ItemKappaCompass.Mode.getModeByIndex(compound.func_74762_e(NBT.COMPASS_MODE.getName())));
        }
        if (compound.func_74764_b(NBT.COMPASS_POS_LIST.getName())) {
            NBTTagList tagList = compound.func_150295_c(NBT.COMPASS_POS_LIST.getName(), 10);
            ArrayList posList = Lists.newArrayList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)tagList.func_150305_b(i));
                posList.add(pos);
            }
            this.compassPosList = posList;
        }
        if (compound.func_74764_b(NBT.CURRENT_INDEX.getName())) {
            this.currentIndex = compound.func_74762_e(NBT.CURRENT_INDEX.getName());
        }
        if (compound.func_74764_b(NBT.DESCENDING.getName())) {
            this.descending = compound.func_74767_n(NBT.DESCENDING.getName());
        }
        if (compound.func_74764_b(NBT.CAN_HOLD_TROLLEY.getName())) {
            this.canHoldTrolley = compound.func_74767_n(NBT.CAN_HOLD_TROLLEY.getName());
        }
        if (compound.func_74764_b(NBT.CAN_HOLD_VEHICLE.getName())) {
            this.canHoldVehicle = compound.func_74767_n(NBT.CAN_HOLD_VEHICLE.getName());
        }
        if (compound.func_74764_b(NBT.CAN_RIDING_BROOM.getName())) {
            this.canRidingBroom = compound.func_74767_n(NBT.CAN_RIDING_BROOM.getName());
        }
        if (compound.func_74764_b(NBT.CAN_RIDING.getName())) {
            this.canRiding = compound.func_74767_n(NBT.CAN_RIDING.getName());
        }
        if (compound.func_74764_b(NBT.SLEEP.getName())) {
            this.setSleep(compound.func_74767_n(NBT.SLEEP.getName()));
        }
        if (compound.func_74764_b(NBT.FAVORABILITY.getName())) {
            this.setFavorability(compound.func_74762_e(NBT.FAVORABILITY.getName()));
        }
        if (compound.func_74764_b(NBT.SHOW_HELMET.getName())) {
            this.setShowHelmet(compound.func_74767_n(NBT.SHOW_HELMET.getName()));
        }
        if (compound.func_74764_b(NBT.JOY_TICK_DATA.getName())) {
            this.joyTickData = JoyType.compoundToJoyTickData(compound.func_74775_l(NBT.JOY_TICK_DATA.getName()));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a(NBT.MAID_INVENTORY.getName(), (NBTBase)this.mainInv.serializeNBT());
        compound.func_74782_a(NBT.BAUBLE_INVENTORY.getName(), (NBTBase)this.baubleInv.serializeNBT());
        compound.func_74757_a(NBT.IS_PICKUP.getName(), this.isPickup());
        compound.func_74778_a(NBT.MAID_TASK.getName(), this.task.getUid().toString());
        compound.func_74768_a(NBT.MAID_EXP.getName(), this.getExp());
        compound.func_74757_a(NBT.MAID_HOME.getName(), this.isHomeModeEnable());
        compound.func_74778_a(NBT.MODEL_ID.getName(), this.getModelId());
        compound.func_74757_a(NBT.STRUCK_BY_LIGHTNING.getName(), this.isStruckByLightning());
        compound.func_74772_a(NBT.SASIMONO_CRC32.getName(), this.getSasimonoCRC32().longValue());
        compound.func_74757_a(NBT.SHOW_SASIMONO.getName(), this.isShowSasimono());
        compound.func_74757_a(NBT.INVULNERABLE.getName(), this.func_190530_aW());
        compound.func_74768_a(NBT.BACKPACK_LEVEL.getName(), this.getBackLevel().getLevel());
        compound.func_74782_a(NBT.MAID_SMALL_BACKPACK.getName(), (NBTBase)this.smallBackpackInv.serializeNBT());
        compound.func_74782_a(NBT.MAID_MIDDLE_BACKPACK.getName(), (NBTBase)this.middleBackpackInv.serializeNBT());
        compound.func_74782_a(NBT.MAID_BIG_BACKPACK.getName(), (NBTBase)this.bigBackpackInv.serializeNBT());
        compound.func_74768_a(NBT.COMPASS_MODE.getName(), this.getCompassMode().ordinal());
        NBTTagList tagList = new NBTTagList();
        for (BlockPos pos : this.compassPosList) {
            tagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a(NBT.COMPASS_POS_LIST.getName(), (NBTBase)tagList);
        compound.func_74768_a(NBT.CURRENT_INDEX.getName(), this.currentIndex);
        compound.func_74757_a(NBT.DESCENDING.getName(), this.descending);
        compound.func_74757_a(NBT.CAN_HOLD_TROLLEY.getName(), this.canHoldTrolley);
        compound.func_74757_a(NBT.CAN_HOLD_VEHICLE.getName(), this.canHoldVehicle);
        compound.func_74757_a(NBT.CAN_RIDING_BROOM.getName(), this.canRidingBroom);
        compound.func_74757_a(NBT.CAN_RIDING.getName(), this.canRiding);
        compound.func_74757_a(NBT.SLEEP.getName(), this.isSleep());
        compound.func_74768_a(NBT.FAVORABILITY.getName(), this.getFavorability());
        compound.func_74757_a(NBT.SHOW_HELMET.getName(), this.isShowHelmet());
        compound.func_74782_a(NBT.JOY_TICK_DATA.getName(), (NBTBase)JoyType.joyTickDataToCompound(this.joyTickData));
    }

    public boolean func_190530_aW() {
        return (Boolean)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    public void func_184224_h(boolean isInvulnerable) {
        super.func_184224_h(isInvulnerable);
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)isInvulnerable);
    }

    public int func_70627_aG() {
        return GeneralConfig.MAID_CONFIG.maidTalkInterval;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        return this.task.getAmbientSound(this);
    }

    protected float func_70647_i() {
        return 1.0f + this.field_70146_Z.nextFloat() * 0.1f;
    }

    public boolean func_70631_g_() {
        return false;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        if (damageSourceIn.func_76347_k()) {
            return MaidSoundEvent.MAID_HURT_FIRE;
        }
        if (damageSourceIn.func_76346_g() instanceof EntityPlayer) {
            if (PLAYER_HURT_SOUND_COUNT == 0) {
                PLAYER_HURT_SOUND_COUNT = GeneralConfig.MAID_CONFIG.maidHurtSoundInterval;
                return MaidSoundEvent.MAID_PLAYER;
            }
            return null;
        }
        return MaidSoundEvent.MAID_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        return MaidSoundEvent.MAID_DEATH;
    }

    public float func_70047_e() {
        return this.field_70131_O * (this.func_70906_o() ? 0.65f : 0.85f);
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        if (this.func_184179_bs() instanceof EntityMarisaBroom) {
            return this.createNavigatorFlying(worldIn);
        }
        return this.createNavigatorGround(worldIn);
    }

    private PathNavigate createNavigatorFlying(World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        pathnavigateflying.func_192879_a(true);
        pathnavigateflying.func_75489_a((double)0.8f);
        return pathnavigateflying;
    }

    private PathNavigate createNavigatorGround(World worldIn) {
        PathNavigateGround pathNavigate = new PathNavigateGround((EntityLiving)this, worldIn){

            protected PathFinder func_179679_a() {
                this.field_179695_a = new MaidNodeProcessor();
                this.field_179695_a.func_186317_a(true);
                return new PathFinder(this.field_179695_a);
            }
        };
        pathNavigate.func_179688_b(true);
        pathNavigate.func_179691_c(true);
        pathNavigate.func_179693_d(true);
        pathNavigate.func_179685_e(false);
        return pathNavigate;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (this.getBackLevel()) {
                default: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.baubleInv}));
                }
                case SMALL: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.smallBackpackInv, this.baubleInv}));
                }
                case MIDDLE: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.smallBackpackInv, this.middleBackpackInv, this.baubleInv}));
                }
                case BIG: 
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.smallBackpackInv, this.middleBackpackInv, this.bigBackpackInv, this.baubleInv}));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public IItemHandlerModifiable getInv(MaidInventory type) {
        switch (type) {
            case HAND: {
                return this.handsInvWrapper;
            }
            case BAUBLE: {
                return this.baubleInv;
            }
            case ARMOR: {
                return this.armorInvWrapper;
            }
            case SMALL_BACKPACK: {
                return this.smallBackpackInv;
            }
            case MIDDLE_BACKPACK: {
                return this.middleBackpackInv;
            }
            case BIG_BACKPACK: {
                return this.bigBackpackInv;
            }
        }
        return this.mainInv;
    }

    @Override
    public BaubleItemHandler getBaubleInv() {
        return this.baubleInv;
    }

    public CombinedInvWrapper getAvailableInv(boolean handsFirst) {
        CombinedInvWrapper combinedInvWrapper;
        switch (this.getBackLevel()) {
            default: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv});
                break;
            }
            case SMALL: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv, this.smallBackpackInv});
                break;
            }
            case MIDDLE: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv, this.smallBackpackInv, this.middleBackpackInv});
                break;
            }
            case BIG: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv, this.smallBackpackInv, this.middleBackpackInv, this.bigBackpackInv});
            }
        }
        return handsFirst ? new CombinedInvWrapper(new IItemHandlerModifiable[]{this.handsInvWrapper, combinedInvWrapper}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{combinedInvWrapper, this.handsInvWrapper});
    }

    public IItemHandlerModifiable getAllBackpackInv() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.smallBackpackInv, this.middleBackpackInv, this.bigBackpackInv});
    }

    public boolean func_110173_bK() {
        return this.func_180485_d(new BlockPos((Entity)this));
    }

    public boolean func_180485_d(@Nonnull BlockPos pos) {
        if (!this.isHomeModeEnable()) {
            return true;
        }
        float maxDistance = this.func_110174_bM();
        BlockPos homePos = this.func_180486_cf();
        if (this.getCompassMode() == ItemKappaCompass.Mode.SET_RANGE && maxDistance != -1.0f) {
            List<BlockPos> posList = this.getCompassPosList(this.getCompassMode());
            int index = posList.size() - 1;
            BlockPos pos1 = posList.get(index);
            BlockPos pos2 = posList.get(--index);
            boolean xIsOkay = Math.min(pos1.func_177958_n(), pos2.func_177958_n()) <= pos.func_177958_n() && pos.func_177958_n() <= Math.max(pos1.func_177958_n(), pos2.func_177958_n());
            boolean yIsOkay = Math.min(pos1.func_177956_o(), pos2.func_177956_o()) <= pos.func_177956_o() && pos.func_177956_o() <= Math.max(pos1.func_177956_o(), pos2.func_177956_o());
            boolean zIsOkay = Math.min(pos1.func_177952_p(), pos2.func_177952_p()) <= pos.func_177952_p() && pos.func_177952_p() <= Math.max(pos1.func_177952_p(), pos2.func_177952_p());
            return xIsOkay && yIsOkay && zIsOkay && this.isHomeModeEnable();
        }
        if (maxDistance == -1.0f) {
            return true;
        }
        return homePos.func_177951_i((Vec3i)pos) < (double)(maxDistance * maxDistance);
    }

    public void func_175449_a(@Nonnull BlockPos pos, int distance) {
        this.leashedPosition = pos;
        this.maximumLeashedDistance = distance;
    }

    @Nonnull
    public BlockPos func_180486_cf() {
        if (this.isLeashedAndInSameWorld()) {
            return this.leashedPosition;
        }
        if (!this.isHomeModeEnable()) {
            return BlockPos.field_177992_a;
        }
        List<BlockPos> posList = this.getCompassPosList(this.getCompassMode());
        if (posList.size() > 0) {
            switch (this.getCompassMode()) {
                case SINGLE_POINT: {
                    return posList.get(0);
                }
                case MULTI_POINT_CLOSURE: 
                case MULTI_POINT_REENTRY: {
                    return posList.get(this.getCurrentIndex());
                }
                case SET_RANGE: {
                    if (posList.size() > 1) {
                        int index = posList.size() - 1;
                        BlockPos tmpPos = posList.get(--index).func_177971_a((Vec3i)posList.get(index));
                        return new BlockPos(tmpPos.func_177958_n() / 2, tmpPos.func_177956_o() / 2, tmpPos.func_177952_p() / 2);
                    }
                }
                case NONE: {
                    return BlockPos.field_177992_a;
                }
            }
        }
        return BlockPos.field_177992_a;
    }

    public float func_110174_bM() {
        if (this.isLeashedAndInSameWorld()) {
            return this.maximumLeashedDistance;
        }
        if (!this.isHomeModeEnable()) {
            return -1.0f;
        }
        List<BlockPos> posList = this.getCompassPosList(this.getCompassMode());
        if (posList.size() > 0) {
            switch (this.getCompassMode()) {
                case SINGLE_POINT: 
                case MULTI_POINT_CLOSURE: 
                case MULTI_POINT_REENTRY: {
                    return 8.0f;
                }
                case SET_RANGE: {
                    if (posList.size() > 1) {
                        int index = posList.size() - 1;
                        return MathHelper.func_76133_a((double)posList.get(--index).func_177951_i((Vec3i)posList.get(index)));
                    }
                }
                case NONE: {
                    return -1.0f;
                }
            }
        }
        return -1.0f;
    }

    public boolean func_110175_bO() {
        if (this.isLeashedAndInSameWorld()) {
            return this.maximumLeashedDistance == -1.0f;
        }
        return this.getCompassMode() != ItemKappaCompass.Mode.NONE && this.isHomeModeEnable();
    }

    private boolean isLeashedAndInSameWorld() {
        return this.func_110167_bD() && this.func_110166_bE() != null && this.func_110166_bE().field_70170_p == this.field_70170_p;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return player.equals((Object)this.func_70902_q()) && super.func_184652_a(player);
    }

    @Nullable
    public EntityLivingBase func_70638_az() {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && super.func_70638_az() instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && super.func_70638_az() instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            return null;
        }
        return super.func_70638_az();
    }

    public void func_70624_b(@Nullable EntityLivingBase entityLivingBase) {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && entityLivingBase instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && entityLivingBase instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            super.func_70624_b(null);
        } else {
            super.func_70624_b(entityLivingBase);
        }
    }

    @Nullable
    public EntityLivingBase func_70643_av() {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && super.func_70643_av() instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && super.func_70643_av() instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            return null;
        }
        return super.func_70643_av();
    }

    public void func_70604_c(@Nullable EntityLivingBase entityLivingBase) {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && entityLivingBase instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && entityLivingBase instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            super.func_70604_c(null);
        } else {
            super.func_70604_c(entityLivingBase);
        }
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)beg);
    }

    @Override
    public boolean isPickup() {
        return (Boolean)this.field_70180_af.func_187225_a(PICKUP);
    }

    public void setPickup(boolean pickup) {
        this.field_70180_af.func_187227_b(PICKUP, (Object)pickup);
    }

    public IMaidTask getTask() {
        return (IMaidTask)LittleMaidAPI.findTask(new ResourceLocation((String)this.field_70180_af.func_187225_a(TASK))).or((Object)LittleMaidAPI.getIdleTask());
    }

    public void setTask(IMaidTask task) {
        if (task == this.task) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.taskAI != null) {
                this.field_70714_bg.func_85156_a(this.taskAI);
            }
            this.taskAI = task.createAI(this);
            if (this.taskAI != null) {
                this.field_70714_bg.func_75776_a(5, this.taskAI);
            }
        }
        this.task = task;
        this.field_70180_af.func_187227_b(TASK, (Object)task.getUid().toString());
    }

    @Override
    public int getExp() {
        return (Integer)this.field_70180_af.func_187225_a(EXP);
    }

    @Override
    public void setExp(int expIn) {
        this.field_70180_af.func_187227_b(EXP, (Object)expIn);
    }

    @Override
    public void addExp(int expIn) {
        this.setExp(this.getExp() + expIn);
    }

    @Override
    public boolean isHomeModeEnable() {
        return (Boolean)this.field_70180_af.func_187225_a(HOME);
    }

    public void setHomeModeEnable(boolean enable) {
        this.field_70180_af.func_187227_b(HOME, (Object)enable);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(ARM_RISE);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(ARM_RISE, (Object)swingingArms);
    }

    @Override
    public String getModelId() {
        return (String)this.field_70180_af.func_187225_a(MODEL_ID);
    }

    @Override
    public void setModelId(String modelId) {
        this.field_70180_af.func_187227_b(MODEL_ID, (Object)modelId);
    }

    public boolean isStruckByLightning() {
        return (Boolean)this.field_70180_af.func_187225_a(STRUCK_BY_LIGHTNING);
    }

    public void setStruckByLightning(boolean isStruck) {
        this.field_70180_af.func_187227_b(STRUCK_BY_LIGHTNING, (Object)isStruck);
    }

    public Long getSasimonoCRC32() {
        return Long.valueOf((String)this.field_70180_af.func_187225_a(SASIMONO_CRC32));
    }

    public void setSasimonoCRC32(Long crc32) {
        this.field_70180_af.func_187227_b(SASIMONO_CRC32, (Object)String.valueOf(crc32));
    }

    @Override
    public boolean hasSasimono() {
        return !((String)this.field_70180_af.func_187225_a(SASIMONO_CRC32)).equals(String.valueOf(0L));
    }

    public boolean isShowSasimono() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOW_SASIMONO);
    }

    public void setShowSasimono(boolean isShow) {
        this.field_70180_af.func_187227_b(SHOW_SASIMONO, (Object)isShow);
    }

    @Override
    public boolean isSleep() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEP);
    }

    public void setSleep(boolean isSleep) {
        this.field_70180_af.func_187227_b(SLEEP, (Object)isSleep);
    }

    public int getFavorability() {
        return (Integer)this.field_70180_af.func_187225_a(FAVORABILITY);
    }

    public void setFavorability(int point) {
        this.field_70180_af.func_187227_b(FAVORABILITY, (Object)point);
    }

    public boolean isShowHelmet() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOW_HELMET);
    }

    public void setShowHelmet(boolean isHide) {
        this.field_70180_af.func_187227_b(SHOW_HELMET, (Object)isHide);
    }

    public EnumBackPackLevel getBackLevel() {
        return EnumBackPackLevel.getEnumLevelByNum((Integer)this.field_70180_af.func_187225_a(BACKPACK_LEVEL));
    }

    @Override
    public CooldownTracker getCooldownTracker() {
        return this.cooldownTracker;
    }

    @Override
    public boolean canDestroyBlock(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_177230_c().canEntityDestroy(state, (IBlockAccess)this.field_70170_p, pos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)state);
    }

    @Override
    public boolean canPlaceBlock(BlockPos pos, IBlockState state) {
        IBlockState oldState = this.field_70170_p.func_180495_p(pos);
        return oldState.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos);
    }

    @Override
    public boolean destroyBlock(BlockPos pos) {
        return this.destroyBlock(pos, true);
    }

    @Override
    public boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        return this.canDestroyBlock(pos) && this.field_70170_p.func_175655_b(pos, dropBlock);
    }

    @Override
    public boolean placeBlock(BlockPos pos, IBlockState state) {
        return this.canPlaceBlock(pos, state) && this.field_70170_p.func_175656_a(pos, state);
    }

    public ItemKappaCompass.Mode getCompassMode() {
        return ItemKappaCompass.Mode.getModeByIndex((Integer)this.field_70180_af.func_187225_a(COMPASS_MODE));
    }

    public void setCompassMode(ItemKappaCompass.Mode mode) {
        this.field_70180_af.func_187227_b(COMPASS_MODE, (Object)mode.ordinal());
    }

    public boolean setCompassPosList(List<BlockPos> posList, ItemKappaCompass.Mode mode) {
        int size = posList.size();
        if (size <= 0) {
            return false;
        }
        switch (mode) {
            case SINGLE_POINT: {
                this.compassPosList = Collections.singletonList(posList.get(size - 1));
                return true;
            }
            case MULTI_POINT_CLOSURE: {
                BlockPos pos2;
                BlockPos pos1;
                if (size > 1 && (pos1 = posList.get(size - 1)).func_177951_i((Vec3i)(pos2 = posList.get(0))) <= Math.pow(16.0, 2.0)) {
                    this.compassPosList = posList;
                    return true;
                }
                return false;
            }
            case MULTI_POINT_REENTRY: {
                if (size > 1) {
                    this.compassPosList = posList;
                    return true;
                }
                return false;
            }
            case SET_RANGE: {
                if (size > 1) {
                    this.compassPosList = Lists.newArrayList((Object[])new BlockPos[]{posList.get(size - 1), posList.get(size - 2)});
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public List<BlockPos> getCompassPosList(ItemKappaCompass.Mode mode) {
        int size = this.compassPosList.size();
        switch (mode) {
            case SINGLE_POINT: {
                if (size > 0) {
                    return Collections.singletonList(this.compassPosList.get(size - 1));
                }
            }
            case MULTI_POINT_CLOSURE: 
            case MULTI_POINT_REENTRY: {
                return this.compassPosList;
            }
            case SET_RANGE: {
                if (size <= 1) break;
                return Lists.newArrayList((Object[])new BlockPos[]{this.compassPosList.get(size - 1), this.compassPosList.get(size - 2)});
            }
        }
        return Lists.newArrayList();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = MathHelper.func_76125_a((int)currentIndex, (int)0, (int)this.compassPosList.size());
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    @Override
    public boolean isCanHoldTrolley() {
        return this.canHoldTrolley && !this.isSleep();
    }

    public void setCanHoldTrolley(boolean canHoldTrolley) {
        this.canHoldTrolley = canHoldTrolley;
    }

    @Override
    public boolean isCanHoldVehicle() {
        return this.canHoldVehicle && !this.isSleep();
    }

    public void setCanHoldVehicle(boolean canHoldVehicle) {
        this.canHoldVehicle = canHoldVehicle;
    }

    @Override
    public boolean isCanRidingBroom() {
        return this.canRidingBroom && !this.isSleep();
    }

    public void setCanRidingBroom(boolean canRidingBroom) {
        this.canRidingBroom = canRidingBroom;
    }

    public boolean isCanRiding() {
        return this.canRiding && !this.isSleep();
    }

    public void setCanRiding(boolean canRiding) {
        this.canRiding = canRiding;
    }

    public Map<String, Integer> getJoyTickData() {
        return this.joyTickData;
    }

    public boolean hasHelmet() {
        return !this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
    }

    public boolean hasChestPlate() {
        return !this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
    }

    public boolean hasLeggings() {
        return !this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
    }

    public boolean hasBoots() {
        return !this.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
    }

    public String getAtBiomeTemp() {
        return this.field_70170_p.func_180494_b(this.func_180425_c()).func_150561_m().name();
    }

    public double getArmorValue() {
        return this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
    }

    public boolean onHurt() {
        return this.field_70737_aN > 0;
    }

    public boolean hasBackpack() {
        return this.getBackLevel() != EnumBackPackLevel.EMPTY;
    }

    public int getBackpackLevel() {
        return this.getBackLevel().getLevel();
    }

    public void setBackpackLevel(EnumBackPackLevel level) {
        this.field_70180_af.func_187227_b(BACKPACK_LEVEL, (Object)MathHelper.func_76125_a((int)level.getLevel(), (int)EnumBackPackLevel.EMPTY.getLevel(), (int)EnumBackPackLevel.BIG.getLevel()));
    }

    public boolean isSitInJoyBlock() {
        return this.func_184187_bx() instanceof EntityMaidJoy;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        EntityModelJson modelJson = CustomResourcesLoader.MAID_MODEL.getModel(this.getModelId()).orElse(null);
        if (modelJson == null) {
            return super.func_184177_bl();
        }
        return modelJson.renderBoundingBox.func_191194_a(this.func_174791_d());
    }

    public static enum EnumBackPackLevel {
        EMPTY(0),
        SMALL(1),
        MIDDLE(2),
        BIG(3);

        private final int level;

        private EnumBackPackLevel(int level) {
            this.level = level;
        }

        public static EnumBackPackLevel getEnumLevelByNum(int num) {
            int numClamp = MathHelper.func_76125_a((int)num, (int)EMPTY.getLevel(), (int)BIG.getLevel());
            return EnumBackPackLevel.values()[numClamp];
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static enum NBT {
        MAID_INVENTORY("MaidInventory"),
        BAUBLE_INVENTORY("BaubleInventory"),
        IS_PICKUP("IsPickup"),
        MAID_TASK("MaidTask"),
        MAID_EXP("MaidExp"),
        MAID_HOME("MaidHome"),
        MODEL_ID("ModelId"),
        STRUCK_BY_LIGHTNING("StruckByLightning"),
        SASIMONO_CRC32("SasimonoCRC32"),
        SHOW_SASIMONO("ShowSasimono"),
        INVULNERABLE("Invulnerable"),
        BACKPACK_LEVEL("BackpackLevel"),
        MAID_SMALL_BACKPACK("MaidSmallBackpack"),
        MAID_MIDDLE_BACKPACK("MaidMiddleBackpack"),
        MAID_BIG_BACKPACK("MaidBigBackpack"),
        COMPASS_MODE("MaidCompassMode"),
        COMPASS_POS_LIST("MaidCompassPosList"),
        CURRENT_INDEX("MaidCurrentIndex"),
        DESCENDING("MaidCurrentDescending"),
        CAN_HOLD_TROLLEY("MaidCanHoldTrolley"),
        CAN_HOLD_VEHICLE("MaidCanHoldVehicle"),
        CAN_RIDING_BROOM("MaidCanRidingBroom"),
        CAN_RIDING("MaidCanRidingEntity"),
        SLEEP("MaidIsSleep"),
        FAVORABILITY("MaidFavorability"),
        SHOW_HELMET("MaidShowHelmet"),
        JOY_TICK_DATA("MaidJoyTickData");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

