/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMaidJoy;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability.EventType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability.FavorabilityEvent;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point2i;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class JoyType {
    public static final Map<String, JoyType> JOYS = Maps.newHashMap();
    private static final int FAVORABILITY_INCREASES_FREQUENCY = 100;
    private static int COUNTER = 0;
    public static final JoyType READING = JoyType.addJoyType("reading", 1200, 36000, new Point2i[]{new Point2i(-1, -1), new Point2i(0, -1), new Point2i(1, -1), new Point2i(1, 0)});
    public static final JoyType PIANO = JoyType.addJoyType("piano", 800, 24000, new Point2i[]{new Point2i(-1, -1), new Point2i(0, -1), new Point2i(1, -1)});
    public static final JoyType LIVE = JoyType.addJoyType("live", 2000, 60000, new Point2i[]{new Point2i(-1, -1), new Point2i(0, -1), new Point2i(1, -1)});
    private final String name;
    private final int joyingTick;
    private final int coolingTick;
    private final int index;
    private final Point2i[] posList;

    public JoyType(String name, int joyingTick, int coolingTick, Point2i[] posList) {
        this.name = name;
        this.joyingTick = joyingTick;
        this.coolingTick = coolingTick;
        this.posList = posList;
        this.index = COUNTER;
    }

    public static JoyType addJoyType(String name, int joyingTick, int coolingTick, Point2i[] posList) {
        JoyType type = new JoyType(name, joyingTick, coolingTick, posList);
        JOYS.put(name, type);
        ++COUNTER;
        return type;
    }

    public static void updateJoyTick(EntityMaid maid, Map<String, Integer> joyTickData) {
        for (String joyTypeName : joyTickData.keySet()) {
            int tick = joyTickData.get(joyTypeName);
            if (tick <= 0) continue;
            joyTickData.put(joyTypeName, --tick);
        }
        if (maid.func_184187_bx() instanceof EntityMaidJoy) {
            String joyTypeName;
            if (maid.field_70173_aa % 100 == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new FavorabilityEvent(EventType.JOY, maid));
            }
            EntityMaidJoy entityMaidJoy = (EntityMaidJoy)maid.func_184187_bx();
            joyTypeName = entityMaidJoy.getType();
            JoyType joyType = JOYS.get(joyTypeName);
            int tick = 0;
            if (joyTickData.containsKey(joyTypeName)) {
                tick = joyTickData.get(joyTypeName);
            }
            if (tick > joyType.coolingTick) {
                maid.func_184210_p();
            } else {
                joyTickData.put(joyTypeName, tick + 1 + joyType.coolingTick / joyType.joyingTick);
            }
        }
    }

    public static NBTTagCompound joyTickDataToCompound(Map<String, Integer> joyTickData) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        for (String joyTypeName : joyTickData.keySet()) {
            tagCompound.func_74768_a(joyTypeName, joyTickData.get(joyTypeName).intValue());
        }
        return tagCompound;
    }

    public static Map<String, Integer> compoundToJoyTickData(NBTTagCompound compound) {
        HashMap joyTickData = Maps.newHashMap();
        for (String name : compound.func_150296_c()) {
            joyTickData.put(name, compound.func_74762_e(name));
        }
        return joyTickData;
    }

    public static boolean canUseJoyType(EntityMaid maid, String type) {
        if (maid.getJoyTickData().containsKey(type)) {
            return maid.getJoyTickData().get(type) <= 0;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public BlockPos[] getPosList(EnumFacing facing) {
        BlockPos[] posListRotation = new BlockPos[this.posList.length + 1];
        double rad = Math.toRadians(facing.func_185119_l() - 180.0f);
        for (int i = 0; i < this.posList.length; ++i) {
            posListRotation[i] = new BlockPos((double)Math.round((double)this.posList[i].getX() * Math.cos(rad) - (double)this.posList[i].getY() * Math.sin(rad)), 0.0, (double)Math.round((double)this.posList[i].getX() * Math.sin(rad) + (double)this.posList[i].getY() * Math.cos(rad)));
        }
        posListRotation[this.posList.length] = BlockPos.field_177992_a;
        return posListRotation;
    }
}

