/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability;

import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public enum Level {
    VERY_HIGH(2048, 20.0f, 80.0f),
    HIGH(512, 10.0f, 40.0f),
    NORMAL(0, 2.0f, 20.0f),
    LOW(-512, 2.0f, 20.0f),
    VERY_LOW(-2048, 2.0f, 20.0f);

    private final int count;
    private final ResourceLocation icon;
    private final float attackValue;
    private final float healthyValue;

    private Level(int count, float attackValue, float healthyValue) {
        this.count = count;
        this.icon = new ResourceLocation("touhou_little_maid", String.format("textures/gui/%s.png", this.name().toLowerCase(Locale.US)));
        this.attackValue = attackValue;
        this.healthyValue = healthyValue;
    }

    public static Level getLevelByCount(int count) {
        for (Level level : Level.values()) {
            if (count < level.getCount()) continue;
            return level;
        }
        return VERY_LOW;
    }

    public Level getNext() {
        return Level.values()[MathHelper.func_76125_a((int)(this.ordinal() - 1), (int)0, (int)(Level.values().length - 1))];
    }

    public Level getPrevious() {
        return Level.values()[MathHelper.func_76125_a((int)(this.ordinal() + 1), (int)0, (int)(Level.values().length - 1))];
    }

    public int getCount() {
        return this.count;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public float getAttackValue() {
        return this.attackValue;
    }

    public float getHealthyValue() {
        return this.healthyValue;
    }
}

