/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.danmaku.EntityDamageSourceDanmaku;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityDanmaku
extends EntityThrowable {
    private static final int MAX_TICKS_EXISTED = 200;
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityDanmaku.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityDanmaku.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityDanmaku.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityDanmaku.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TICKS_EXISTED = EntityDataManager.func_187226_a(EntityDanmaku.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DAMAGES_TERRAIN = EntityDataManager.func_187226_a(EntityDanmaku.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityDanmaku(World worldIn) {
        super(worldIn);
    }

    public EntityDanmaku(World worldIn, EntityLivingBase throwerIn, DanmakuType type, DanmakuColor color) {
        super(worldIn, throwerIn);
        this.func_184212_Q().func_187227_b(TYPE, (Object)type.ordinal());
        this.func_184212_Q().func_187227_b(COLOR, (Object)color.ordinal());
    }

    public EntityDanmaku(World worldIn, EntityLivingBase throwerIn, float damage, float gravity, DanmakuType type, DanmakuColor color) {
        super(worldIn, throwerIn);
        this.func_184212_Q().func_187227_b(TYPE, (Object)type.ordinal());
        this.func_184212_Q().func_187227_b(COLOR, (Object)color.ordinal());
        this.func_184212_Q().func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        this.func_184212_Q().func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TYPE, (Object)DanmakuType.PELLET.ordinal());
        this.func_184212_Q().func_187214_a(COLOR, (Object)DanmakuColor.RED.ordinal());
        this.func_184212_Q().func_187214_a(DAMAGE, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(GRAVITY, (Object)Float.valueOf(0.01f));
        this.func_184212_Q().func_187214_a(TICKS_EXISTED, (Object)200);
        this.func_184212_Q().func_187214_a(DAMAGES_TERRAIN, (Object)false);
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            boolean hitMaidHasSasimono;
            boolean throwerMaidHasSasimono = this.func_85052_h() instanceof EntityMaid && ((EntityMaid)this.func_85052_h()).hasSasimono();
            boolean bl = hitMaidHasSasimono = result.field_72308_g instanceof EntityMaid && ((EntityMaid)result.field_72308_g).hasSasimono();
            if (throwerMaidHasSasimono || hitMaidHasSasimono) {
                this.applyHasHataSasimonoLogic(result);
            } else {
                this.applyNormalEntityHitLogic(result);
            }
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.applyBlockHitLogic(result);
        }
    }

    private void applyHasHataSasimonoLogic(@Nonnull RayTraceResult result) {
        boolean throwerIsTameableAndHitIsPlayerOwner;
        EntityLivingBase thrower = this.func_85052_h();
        Entity hit = result.field_72308_g;
        boolean throwerAndHitHasSameOwner = thrower instanceof EntityTameable && hit instanceof EntityTameable && ((EntityTameable)thrower).func_184753_b() != null && ((EntityTameable)thrower).func_184753_b().equals(((EntityTameable)hit).func_184753_b());
        boolean throwerIsPlayerAndHitIsOwnerTameable = thrower instanceof EntityPlayer && hit instanceof EntityTameable && thrower.func_110124_au().equals(((EntityTameable)hit).func_184753_b());
        boolean bl = throwerIsTameableAndHitIsPlayerOwner = thrower instanceof EntityTameable && hit instanceof EntityPlayer && ((EntityTameable)thrower).func_184753_b() != null && ((EntityTameable)thrower).func_184753_b().equals(hit.func_110124_au());
        if (throwerAndHitHasSameOwner || throwerIsPlayerAndHitIsOwnerTameable || throwerIsTameableAndHitIsPlayerOwner) {
            this.func_70106_y();
        } else {
            this.applyNormalEntityHitLogic(result);
        }
    }

    private void applyNormalEntityHitLogic(@Nonnull RayTraceResult result) {
        if (this.func_85052_h() != null && !result.field_72308_g.equals((Object)this.field_70192_c)) {
            EntityDamageSourceDanmaku source = new EntityDamageSourceDanmaku((Entity)this, (Entity)this.func_85052_h());
            result.field_72308_g.func_70097_a((DamageSource)source, this.getDamage());
            this.func_70106_y();
        }
    }

    private void applyBlockHitLogic(@Nonnull RayTraceResult result) {
        if (this.field_70170_p.func_180495_p(result.func_178782_a()).func_185890_d((IBlockAccess)this.field_70170_p, result.func_178782_a()) != null) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getType() == DanmakuType.MASTER_SPARK && this.field_70173_aa > 40) {
            this.masterSparkLogic();
        }
        if (this.field_70173_aa > this.getDanmakuTicksExisted()) {
            this.func_70106_y();
        }
    }

    private void masterSparkLogic() {
        Vec3d v;
        int i;
        if (this.field_70173_aa % 8 == 0) {
            for (i = 0; i < 4; ++i) {
                v = this.func_174791_d().func_178787_e(new Vec3d(0.0, 0.0, (double)(i * 16 + 8)).func_178789_a(this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(this.field_70177_z * ((float)Math.PI / 180)));
                this.field_70170_p.func_72876_a((Entity)this, v.field_72450_a, v.field_72448_b, v.field_72449_c, (float)(3 + this.field_70146_Z.nextInt(2)), this.isDamagesTerrain());
            }
        }
        if (this.field_70173_aa % 8 == 4) {
            for (i = 0; i < 4; ++i) {
                v = this.func_174791_d().func_178787_e(new Vec3d(0.0, 0.0, (double)(i * 16 + 16)).func_178789_a(this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(this.field_70177_z * ((float)Math.PI / 180)));
                this.field_70170_p.func_72876_a((Entity)this, v.field_72450_a, v.field_72448_b, v.field_72449_c, (float)(3 + this.field_70146_Z.nextInt(2)), this.isDamagesTerrain());
            }
        }
    }

    public boolean func_70090_H() {
        return GeneralConfig.MISC_CONFIG.danmakuAffectedByFluid && super.func_70090_H();
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        if (compound.func_74764_b(NBT.DANMAKU_TYPE.getName())) {
            this.setType(DanmakuType.getType(compound.func_74762_e(NBT.DANMAKU_TYPE.getName())));
        }
        if (compound.func_74764_b(NBT.DANMAKU_COLOR.getName())) {
            this.setColor(DanmakuColor.getColor(compound.func_74762_e(NBT.DANMAKU_COLOR.getName())));
        }
        if (compound.func_74764_b(NBT.DANMAKU_DAMAGE.getName())) {
            this.setDamage(compound.func_74760_g(NBT.DANMAKU_DAMAGE.getName()));
        }
        if (compound.func_74764_b(NBT.DANMAKU_GRAVITY.getName())) {
            this.setGravityVelocity(compound.func_74760_g(NBT.DANMAKU_GRAVITY.getName()));
        }
        if (compound.func_74764_b(NBT.DANMAKU_TICKS_EXISTED.getName())) {
            this.setDanmakuTicksExisted(compound.func_74762_e(NBT.DANMAKU_TICKS_EXISTED.getName()));
        }
        if (compound.func_74764_b(NBT.DANMAKU_DAMAGE.getName())) {
            this.setDamagesTerrain(compound.func_74767_n(NBT.DANMAKU_DAMAGE.getName()));
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        compound.func_74768_a(NBT.DANMAKU_TYPE.getName(), this.getType().ordinal());
        compound.func_74768_a(NBT.DANMAKU_COLOR.getName(), this.getColor().ordinal());
        compound.func_74776_a(NBT.DANMAKU_DAMAGE.getName(), this.getDamage());
        compound.func_74776_a(NBT.DANMAKU_GRAVITY.getName(), this.func_70185_h());
        compound.func_74768_a(NBT.DANMAKU_TICKS_EXISTED.getName(), this.getDanmakuTicksExisted());
        compound.func_74757_a(NBT.DANMAKU_DAMAGES_TERRAIN.getName(), this.isDamagesTerrain());
        return compound;
    }

    protected float func_70185_h() {
        return ((Float)this.func_184212_Q().func_187225_a(GRAVITY)).floatValue();
    }

    public void setGravityVelocity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
    }

    public DanmakuType getType() {
        return DanmakuType.getType((Integer)this.func_184212_Q().func_187225_a(TYPE));
    }

    public void setType(DanmakuType type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    public DanmakuColor getColor() {
        return DanmakuColor.getColor((Integer)this.func_184212_Q().func_187225_a(COLOR));
    }

    public void setColor(DanmakuColor color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color.ordinal());
    }

    public float getDamage() {
        return ((Float)this.func_184212_Q().func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getDanmakuTicksExisted() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_EXISTED);
    }

    public void setDanmakuTicksExisted(int ticksExisted) {
        this.field_70180_af.func_187227_b(TICKS_EXISTED, (Object)ticksExisted);
    }

    public boolean isDamagesTerrain() {
        return (Boolean)this.field_70180_af.func_187225_a(DAMAGES_TERRAIN);
    }

    public void setDamagesTerrain(boolean isDamagesTerrain) {
        this.field_70180_af.func_187227_b(DAMAGES_TERRAIN, (Object)isDamagesTerrain);
    }

    static enum NBT {
        DANMAKU_TYPE("DanmakuType"),
        DANMAKU_COLOR("DanmakuColor"),
        DANMAKU_DAMAGE("DanmakuDamage"),
        DANMAKU_GRAVITY("DanmakuGravity"),
        DANMAKU_TICKS_EXISTED("DanmakuTicksExisted"),
        DANMAKU_DAMAGES_TERRAIN("DanmakuDamagesTerrain");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

