/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.capability.HasGuideHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.HasGuideSerializer;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumSerializer;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerSerializer;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncOwnerMaidNumMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncPowerMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="touhou_little_maid")
public class PlayerCapabilitiesEvent {
    private static final ResourceLocation POWER_CAP = new ResourceLocation("touhou_little_maid", "power");
    private static final ResourceLocation MAID_NUM_CAP = new ResourceLocation("touhou_little_maid", "owner_maid_num");
    private static final ResourceLocation HAS_GUIDE_CAP = new ResourceLocation("touhou_little_maid", "has_guide");

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(POWER_CAP, (ICapabilityProvider)new PowerSerializer());
            event.addCapability(MAID_NUM_CAP, (ICapabilityProvider)new MaidNumSerializer());
            event.addCapability(HAS_GUIDE_CAP, (ICapabilityProvider)new HasGuideSerializer());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        PowerHandler power = (PowerHandler)player.getCapability(PowerSerializer.POWER_CAP, null);
        PowerHandler oldPower = (PowerHandler)event.getOriginal().getCapability(PowerSerializer.POWER_CAP, null);
        if (power != null && oldPower != null) {
            if (event.isWasDeath()) {
                power.set(oldPower.get() - (float)GeneralConfig.MISC_CONFIG.playerDeathLossPowerPoint);
            } else {
                power.set(oldPower.get());
            }
        }
        MaidNumHandler num = (MaidNumHandler)player.getCapability(MaidNumSerializer.MAID_NUM_CAP, null);
        MaidNumHandler oldNum = (MaidNumHandler)event.getOriginal().getCapability(MaidNumSerializer.MAID_NUM_CAP, null);
        if (num != null && oldNum != null) {
            num.set(oldNum.get());
        }
        HasGuideHandler hasGuide = (HasGuideHandler)player.getCapability(HasGuideSerializer.HAS_GUIDE_CAP, null);
        HasGuideHandler oldHasGuide = (HasGuideHandler)event.getOriginal().getCapability(HasGuideSerializer.HAS_GUIDE_CAP, null);
        if (hasGuide != null && oldHasGuide != null) {
            hasGuide.setFirst(oldHasGuide.isFirst());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            MaidNumHandler num;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            PowerHandler power = (PowerHandler)player.getCapability(PowerSerializer.POWER_CAP, null);
            if (power != null) {
                power.markDirty();
            }
            if ((num = (MaidNumHandler)player.getCapability(MaidNumSerializer.MAID_NUM_CAP, null)) != null) {
                num.markDirty();
            }
        }
    }

    @SubscribeEvent
    public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            MaidNumHandler num;
            PowerHandler power;
            if (player.hasCapability(PowerSerializer.POWER_CAP, null) && (power = (PowerHandler)player.getCapability(PowerSerializer.POWER_CAP, null)) != null && power.isDirty()) {
                CommonProxy.INSTANCE.sendTo((IMessage)new SyncPowerMessage(power.get()), (EntityPlayerMP)player);
                power.setDirty(false);
            }
            if (player.hasCapability(MaidNumSerializer.MAID_NUM_CAP, null) && (num = (MaidNumHandler)player.getCapability(MaidNumSerializer.MAID_NUM_CAP, null)) != null && num.isDirty()) {
                CommonProxy.INSTANCE.sendTo((IMessage)new SyncOwnerMaidNumMessage(num.get()), (EntityPlayerMP)player);
                num.setDirty(false);
            }
        }
    }
}

