/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.capability.HasGuideHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.HasGuideSerializer;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncCustomSpellCardData;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="touhou_little_maid")
public class PlayerEnterServer {
    @SubscribeEvent
    public static void onPlayerEnterServer(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PlayerEnterServer.giveGuideBook(player);
        }
    }

    private static void syncSpellCard(EntityPlayerMP player) {
        TouhouLittleMaid.LOGGER.info("Sending custom spell data to {}", (Object)player.getDisplayNameString());
        CommonProxy.INSTANCE.sendTo((IMessage)new SyncCustomSpellCardData(), player);
    }

    private static void giveGuideBook(EntityPlayerMP player) {
        HasGuideHandler hasGuide = (HasGuideHandler)player.getCapability(HasGuideSerializer.HAS_GUIDE_CAP, null);
        if (hasGuide != null && hasGuide.isFirst()) {
            Item item = Item.func_111206_d((String)"patchouli:guide_book");
            if (item != null && GeneralConfig.MISC_CONFIG.giveGuideBookFirst) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("patchouli:book", "touhou_little_maid:memorizable_gensokyo");
                ItemStack stack = new ItemStack(item);
                stack.func_77982_d(tag);
                EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
                player.field_70170_p.func_72838_d((Entity)entityItem);
            }
            if (GeneralConfig.MAID_CONFIG.giveInitMaid) {
                ItemStack stack = new ItemStack(MaidItems.SMART_SLAB);
                EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
                player.field_70170_p.func_72838_d((Entity)entityItem);
            }
            hasGuide.setFirst(false);
        }
    }
}

