/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.internal.task;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaidPredicate;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskAttackRanged;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class TaskAttackDanmaku
extends TaskAttackRanged {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "danmaku_attack");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(MaidItems.HAKUREI_GOHEI);
    }

    @Override
    public SoundEvent getAmbientSound(AbstractEntityMaid maid) {
        return MaidSoundEvent.MAID_DANMAKU_ATTACK;
    }

    @Override
    public void onRangedAttack(AbstractEntityMaid maid, EntityLivingBase target, float distanceFactor) {
        World world = maid.field_70170_p;
        Random rand = maid.func_70681_au();
        List entityList = world.func_175674_a((Entity)maid, maid.func_174813_aQ().func_72321_a(8.0, 3.0, 8.0).func_72321_a(-8.0, -3.0, -8.0), EntityMaidPredicate.IS_MOB);
        if (maid.hasSasimono()) {
            boolean targetIsPlayerOwner;
            boolean targetIsTameableHasSameOwner = target instanceof EntityTameable && ((EntityTameable)target).func_184753_b() != null && ((EntityTameable)target).func_184753_b().equals(maid.func_184753_b());
            boolean bl = targetIsPlayerOwner = target instanceof EntityPlayer && target.func_110124_au().equals(maid.func_184753_b());
            if (targetIsTameableHasSameOwner || targetIsPlayerOwner) {
                return;
            }
        }
        if (entityList.size() <= 1) {
            DanmakuShoot.aimedShot(world, (EntityLivingBase)maid, target, 2.0f * (distanceFactor + 1.0f), 0.0f, Float.valueOf(0.3f * (distanceFactor + 1.0f)), Float.valueOf(0.2f), DanmakuType.getType(rand.nextInt(2)), DanmakuColor.getColor(rand.nextInt(7)));
        } else if (entityList.size() <= 5) {
            DanmakuShoot.fanShapedShot(world, (EntityLivingBase)maid, target, 2.0f * (distanceFactor + 1.2f), 0.0f, Float.valueOf(0.3f * (distanceFactor + 1.0f)), Float.valueOf(0.2f), DanmakuType.getType(rand.nextInt(2)), DanmakuColor.getColor(rand.nextInt(7)), 1.0471975511965976, 8);
        } else {
            DanmakuShoot.fanShapedShot(world, (EntityLivingBase)maid, target, 2.0f * (distanceFactor + 1.5f), 0.0f, Float.valueOf(0.3f * (distanceFactor + 1.0f)), Float.valueOf(0.2f), DanmakuType.getType(rand.nextInt(2)), DanmakuColor.getColor(rand.nextInt(7)), 2.0943951023931953, 32);
        }
        maid.func_184614_ca().func_77972_a(1, (EntityLivingBase)maid);
    }
}

