/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.internal.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.FarmHandler;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.util.EmptyBlockReader;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class VanillaNormalFarmHandler
implements FarmHandler {
    private static final ResourceLocation NAME = new ResourceLocation("touhou_little_maid", "farm");
    private static final Map<Item, ItemStack> CROP_MAP = Maps.newHashMap();

    public static void readInnerCropFile() {
        CROP_MAP.clear();
        try (InputStream stream = TouhouLittleMaid.class.getClassLoader().getResourceAsStream("assets/touhou_little_maid/config/crop.json");){
            if (stream == null) {
                return;
            }
            Map read = (Map)CommonProxy.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<Map<String, Crop>>(){}.getType());
            for (String id : read.keySet()) {
                Crop crop = (Crop)read.get(id);
                Item itemKey = Item.func_111206_d((String)id);
                Item itemValue = Item.func_111206_d((String)crop.id);
                if (itemKey == null || itemValue == null) continue;
                ItemStack stackOut = crop.nbt != null ? new ItemStack(itemValue, crop.count, crop.meta, JsonToNBT.func_180713_a((String)crop.nbt)) : new ItemStack(itemValue, crop.count, crop.meta);
                CROP_MAP.put(itemKey, stackOut);
            }
        }
        catch (IOException | NBTException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IPlantable) {
            if (item == Items.field_151075_bm) {
                return true;
            }
            IPlantable plantable = (IPlantable)stack.func_77973_b();
            return plantable.getPlantType((IBlockAccess)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a) == EnumPlantType.Crop && plantable.getPlant((IBlockAccess)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a).func_177230_c() != Blocks.field_150350_a;
        }
        return false;
    }

    @Override
    public boolean canHarvest(AbstractEntityMaid maid, World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockCrops && ((BlockCrops)block).func_185525_y(state)) {
            return true;
        }
        return block == Blocks.field_150388_bm && (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) >= 3;
    }

    @Override
    public void harvest(AbstractEntityMaid maid, World world, BlockPos pos, IBlockState state) {
        if (maid.func_184614_ca().func_77973_b() instanceof ItemHoe) {
            maid.destroyBlock(pos);
        } else {
            Block block = state.func_177230_c();
            if (block instanceof BlockCrops) {
                BlockCrops crop = (BlockCrops)block;
                Item cropItemDropped = crop.func_180660_a(state, world.field_73012_v, 0);
                if (CROP_MAP.containsKey(cropItemDropped)) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)CROP_MAP.get(cropItemDropped).func_77946_l());
                } else {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(cropItemDropped));
                }
                world.func_175656_a(pos, crop.func_176223_P());
                return;
            }
            if (block == Blocks.field_150388_bm) {
                world.func_175656_a(pos, Blocks.field_150388_bm.func_176223_P());
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151075_bm));
            }
        }
    }

    @Override
    public boolean canPlant(AbstractEntityMaid maid, World world, BlockPos pos, ItemStack seed) {
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        IPlantable plantable = (IPlantable)seed.func_77973_b();
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, plantable);
    }

    @Override
    public ItemStack plant(AbstractEntityMaid maid, World world, BlockPos pos, ItemStack seed) {
        IPlantable plantable = (IPlantable)seed.func_77973_b();
        IBlockState seedState = plantable.getPlant((IBlockAccess)world, pos);
        if (seedState.func_177230_c() != Blocks.field_150350_a && maid.placeBlock(pos, seedState)) {
            seed.func_190918_g(1);
        }
        return seed;
    }

    static class Crop {
        private String id;
        private int meta = 0;
        private int count = 1;
        private String nbt;

        Crop() {
        }
    }
}

