/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory;

import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ChangeMaidTaskMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MaidMainContainer
extends Container {
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public EntityMaid maid;
    public int taskIndex;
    public IMaidTask task;

    public MaidMainContainer(IInventory playerInventory, EntityMaid maid, int taskIndex) {
        this.addEntityArmorAndHandSlots(maid);
        this.addPlayerSlots(playerInventory);
        this.maid = maid;
        this.taskIndex = 0 < taskIndex && taskIndex < LittleMaidAPI.getTasks().size() ? taskIndex : 0;
        this.task = LittleMaidAPI.getTasks().get(this.taskIndex);
        maid.guiOpening = true;
        maid.setTask(LittleMaidAPI.getIdleTask());
    }

    public void func_75142_b() {
        this.maid.guiOpening = true;
        super.func_75142_b();
    }

    public void func_75134_a(EntityPlayer playerIn) {
        this.maid.guiOpening = false;
        if (playerIn.field_70170_p.field_72995_K) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new ChangeMaidTaskMessage(this.maid.func_110124_au(), this.task));
        }
        super.func_75134_a(playerIn);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return this.maid.func_184753_b() != null && this.maid.func_184753_b().equals(playerIn.func_110124_au()) && this.maid.func_70089_S() && !this.maid.isSleep() && this.maid.func_70032_d((Entity)playerIn) < 5.0f;
    }

    private void addPlayerSlots(IInventory playerInventory) {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot(playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot(playerInventory, i1, 8 + i1 * 18, 142));
        }
    }

    private void addEntityArmorAndHandSlots(EntityMaid entityMaid) {
        IItemHandler itemHandler = (IItemHandler)entityMaid.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.addArmorSlot(entityMaid, itemHandler);
        this.addHandSlot(itemHandler);
    }

    private void addArmorSlot(final EntityMaid entityMaid, IItemHandler itemHandler) {
        for (int k = 0; k < 4; ++k) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[k];
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 3 - k, 8, 8 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)entityMaid) && super.func_75214_a(stack);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
    }

    private void addHandSlot(IItemHandler itemHandler) {
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 4, 80, 62));
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 5, 98, 62){

            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 6 ? !this.func_75135_a(itemstack1, 6, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, 6, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

