/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPhoto;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.util.ItemFindUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemAlbum
extends Item {
    public static final int ALBUM_INV_SIZE = 32;

    public ItemAlbum() {
        this.func_77655_b("touhou_little_maid.album");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    public static ItemStackHandler getAlbumInv(ItemStack album) {
        NBTTagCompound tag;
        AlbumItemStackHandler handler = new AlbumItemStackHandler(32);
        if (album.func_77973_b() instanceof ItemAlbum && (tag = album.func_77978_p()) != null && tag.func_150297_b(NBT.INVENTORY.getName(), 10)) {
            NBTTagCompound tagInv = tag.func_74775_l(NBT.INVENTORY.getName());
            handler.deserializeNBT(tagInv);
        }
        return handler;
    }

    public static void setAlbumInv(ItemStack album, ItemStackHandler itemStackHandler) {
        if (album.func_77973_b() instanceof ItemAlbum) {
            NBTTagCompound tag = album.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74782_a(NBT.INVENTORY.getName(), (NBTBase)itemStackHandler.serializeNBT());
            album.func_77982_d(tag);
        }
    }

    public static int getAlbumPhotoNum(ItemStack album) {
        NBTTagCompound tag;
        if (album.func_77973_b() instanceof ItemAlbum && album.func_77942_o() && album.func_77978_p().func_150297_b(NBT.INVENTORY.getName(), 10) && (tag = album.func_77978_p().func_74775_l(NBT.INVENTORY.getName())).func_150297_b("Size", 3) && tag.func_150297_b("Items", 9)) {
            return tag.func_150295_c("Items", 10).func_74745_c();
        }
        return 0;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemAlbum && player.func_184586_b(hand).func_77942_o() && player.func_184586_b(hand).func_77978_p().func_150297_b(NBT.INVENTORY.getName(), 10)) {
            ItemStack album = player.func_184586_b(hand);
            ItemStackHandler itemStackHandler = ItemAlbum.getAlbumInv(album);
            ItemStack photo = ItemFindUtil.getStack((IItemHandler)itemStackHandler, stack -> stack.func_77973_b() instanceof ItemPhoto);
            if (!photo.func_190926_b() && ItemPhoto.onPhotoUse(player, worldIn, pos, facing, hitX, hitY, hitZ, photo) == EnumActionResult.SUCCESS) {
                ItemAlbum.setAlbumInv(album, itemStackHandler);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (handIn == EnumHand.MAIN_HAND && playerIn.func_184586_b(handIn).func_77973_b() instanceof ItemAlbum) {
            playerIn.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.ALBUM.getId(), worldIn, 0, 0, 0);
            playerIn.func_184185_a(MaidSoundEvent.ALBUM_OPEN, 0.8f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int photoNum = ItemAlbum.getAlbumPhotoNum(stack);
        if (photoNum > 0) {
            tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.album.desc", (Object[])new Object[]{photoNum, 32}));
        }
    }

    private static class AlbumItemStackHandler
    extends ItemStackHandler {
        private AlbumItemStackHandler(int size) {
            super(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemPhoto;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }

    static enum NBT {
        INVENTORY("AlbumInventory");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

