/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPhoto;
import com.github.tartaricacid.touhoulittlemaid.util.MaidRayTraceHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemCamera
extends Item {
    public ItemCamera() {
        this.func_77655_b("touhou_little_maid.camera");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
        this.func_77656_e(50);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (handIn == EnumHand.MAIN_HAND) {
            int searchDistance = 8;
            ItemStack camera = playerIn.func_184586_b(handIn);
            Optional<EntityMaid> result = MaidRayTraceHelper.rayTraceMaid(playerIn, searchDistance);
            if (result.isPresent()) {
                EntityMaid maid = result.get();
                if (!worldIn.field_72995_K && maid.func_70089_S() && maid.func_152114_e((EntityLivingBase)playerIn)) {
                    if (maid.getBackLevel() != EntityMaid.EnumBackPackLevel.EMPTY) {
                        this.spawnMaidBackpack(worldIn, maid);
                    }
                    this.spawnMaidPhoto(worldIn, maid, playerIn);
                    maid.func_70106_y();
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 20);
                    camera.func_77972_a(1, (EntityLivingBase)playerIn);
                }
                maid.func_70656_aK();
                playerIn.func_184185_a(MaidSoundEvent.CAMERA_USE, 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void spawnMaidBackpack(World worldIn, EntityMaid maid) {
        EntityBackpack backpack = new EntityBackpack(worldIn, maid.getBackLevel());
        IItemHandlerModifiable maidBackpackInv = maid.getAllBackpackInv();
        ItemStackHandler backpackInv = backpack.getInv();
        for (int i = 0; i < maidBackpackInv.getSlots(); ++i) {
            backpackInv.setStackInSlot(i, maidBackpackInv.getStackInSlot(i));
        }
        backpack.func_70080_a(maid.field_70165_t, maid.field_70163_u, maid.field_70161_v, maid.field_70761_aq, maid.field_70125_A);
        worldIn.func_72838_d((Entity)backpack);
    }

    private void spawnMaidPhoto(World worldIn, EntityMaid maid, EntityPlayer playerIn) {
        ItemStack photo = new ItemStack(MaidItems.PHOTO);
        NBTTagCompound photoTag = new NBTTagCompound();
        NBTTagCompound maidTag = new NBTTagCompound();
        maid.func_70014_b(maidTag);
        this.removeMaidBackpackTagData(maidTag);
        photoTag.func_74782_a(ItemPhoto.NBT.MAID_INFO.getNbtName(), (NBTBase)maidTag);
        photo.func_77982_d(photoTag);
        if (maid.func_145818_k_()) {
            photo.func_151001_c(maid.func_95999_t());
        }
        InventoryHelper.func_180173_a((World)worldIn, (double)playerIn.field_70165_t, (double)playerIn.field_70163_u, (double)playerIn.field_70161_v, (ItemStack)photo);
    }

    private void removeMaidBackpackTagData(NBTTagCompound nbt) {
        nbt.func_82580_o(EntityMaid.NBT.BACKPACK_LEVEL.getName());
        nbt.func_82580_o(EntityMaid.NBT.MAID_SMALL_BACKPACK.getName());
        nbt.func_82580_o(EntityMaid.NBT.MAID_MIDDLE_BACKPACK.getName());
        nbt.func_82580_o(EntityMaid.NBT.MAID_BIG_BACKPACK.getName());
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (stack.func_77973_b() == this && target.func_70089_S() && target instanceof EntityMaid && ((EntityMaid)target).func_152114_e((EntityLivingBase)playerIn)) {
            this.func_77659_a(playerIn.field_70170_p, playerIn, hand);
            return true;
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltips.touhou_little_maid.camera.desc", (Object[])new Object[0]));
    }
}

