/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChair
extends Item {
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";
    private static final float DEFAULT_MOUNTED_HEIGHT = 0.0f;
    private static final boolean DEFAULT_TAMEABLE_CAN_RIDE = true;

    public ItemChair() {
        this.func_77655_b("touhou_little_maid.chair");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.CHAIR_TABS);
    }

    public static String getChairModelId(ItemStack stack) {
        if (stack.func_77973_b() == MaidItems.CHAIR && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT.MODEL_ID.getName())) {
            return stack.func_77978_p().func_74779_i(NBT.MODEL_ID.getName());
        }
        return DEFAULT_MODEL_ID;
    }

    private static ItemStack setChairModelId(ItemStack stack, String modelId) {
        if (stack.func_77973_b() == MaidItems.CHAIR) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74778_a(NBT.MODEL_ID.getName(), modelId);
            } else {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(NBT.MODEL_ID.getName(), modelId);
                stack.func_77982_d(tag);
            }
        }
        return stack;
    }

    public static float getMountedHeight(ItemStack stack) {
        if (stack.func_77973_b() == MaidItems.CHAIR && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT.MOUNTED_HEIGHT.getName())) {
            return stack.func_77978_p().func_74760_g(NBT.MOUNTED_HEIGHT.getName());
        }
        return 0.0f;
    }

    private static ItemStack setMountedHeight(ItemStack stack, float height) {
        if (stack.func_77973_b() == MaidItems.CHAIR) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74776_a(NBT.MOUNTED_HEIGHT.getName(), height);
            } else {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74776_a(NBT.MOUNTED_HEIGHT.getName(), height);
                stack.func_77982_d(tag);
            }
        }
        return stack;
    }

    public static boolean isTameableCanRide(ItemStack stack) {
        if (stack.func_77973_b() == MaidItems.CHAIR && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT.TAMEABLE_CAN_RIDE.getName())) {
            return stack.func_77978_p().func_74767_n(NBT.TAMEABLE_CAN_RIDE.getName());
        }
        return true;
    }

    private static ItemStack setTameableCanRide(ItemStack stack, boolean canRide) {
        if (stack.func_77973_b() == MaidItems.CHAIR) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74757_a(NBT.TAMEABLE_CAN_RIDE.getName(), canRide);
            } else {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74757_a(NBT.TAMEABLE_CAN_RIDE.getName(), canRide);
                stack.func_77982_d(tag);
            }
        }
        return stack;
    }

    public static boolean isNoGravity(ItemStack stack) {
        if (stack.func_77973_b() == MaidItems.CHAIR && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT.IS_NO_GRAVITY.getName())) {
            return stack.func_77978_p().func_74767_n(NBT.IS_NO_GRAVITY.getName());
        }
        return false;
    }

    private static ItemStack setNoGravity(ItemStack stack, boolean isNoGravity) {
        if (stack.func_77973_b() == MaidItems.CHAIR) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74757_a(NBT.IS_NO_GRAVITY.getName(), isNoGravity);
            } else {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74757_a(NBT.IS_NO_GRAVITY.getName(), isNoGravity);
                stack.func_77982_d(tag);
            }
        }
        return stack;
    }

    public static ItemStack setAllTagData(ItemStack stack, String modelId, float height, boolean canRide, boolean isNoGravity) {
        ItemChair.setChairModelId(stack, modelId);
        ItemChair.setMountedHeight(stack, height);
        ItemChair.setTameableCanRide(stack, canRide);
        ItemChair.setNoGravity(stack, isNoGravity);
        return stack;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing == EnumFacing.UP) {
            ItemStack itemstack = player.func_184586_b(hand);
            float yaw = (float)MathHelper.func_76141_d((float)((MathHelper.func_76142_g((float)(player.field_70177_z - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
            EntityChair chair = new EntityChair(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p() + 0.5, yaw);
            chair.setModelId(ItemChair.getChairModelId(itemstack));
            chair.setMountedHeight(ItemChair.getMountedHeight(itemstack));
            chair.setTameableCanRide(ItemChair.isTameableCanRide(itemstack));
            chair.func_189654_d(ItemChair.isNoGravity(itemstack));
            if (itemstack.func_82837_s()) {
                chair.func_96094_a(itemstack.func_82833_r());
            }
            player.func_184586_b(hand).func_190918_g(1);
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)chair);
            }
            chair.field_70759_as = yaw;
            chair.func_184185_a(SoundEvents.field_187552_ah, 1.0f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            if (GeneralConfig.MISC_CONFIG.fastRendering) {
                items.add((Object)new ItemStack((Item)this));
            } else {
                for (String key : CustomResourcesLoader.CHAIR_MODEL.getModelIdSet()) {
                    float height = CustomResourcesLoader.CHAIR_MODEL.getModelMountedYOffset(key);
                    boolean canRide = CustomResourcesLoader.CHAIR_MODEL.getModelTameableCanRide(key);
                    boolean isNoGravity = CustomResourcesLoader.CHAIR_MODEL.getModelNoGravity(key);
                    items.add((Object)ItemChair.setAllTagData(new ItemStack((Item)this), key, height, canRide, isNoGravity));
                }
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && CustomResourcesLoader.CHAIR_MODEL.getInfo(ItemChair.getChairModelId(stack)).isPresent()) {
            String name = CustomResourcesLoader.CHAIR_MODEL.getInfo(ItemChair.getChairModelId(stack)).get().getName();
            return ParseI18n.parse(name);
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.chair.place.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.chair.destroy.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.chair.gui.desc", (Object[])new Object[0]));
        if (flagIn.func_194127_a() && GuiScreen.func_146272_n() && stack.func_77942_o()) {
            tooltip.add(String.format("Model Id: %s", ItemChair.getChairModelId(stack)));
            tooltip.add(String.format("Mounted Height: %f", Float.valueOf(ItemChair.getMountedHeight(stack))));
            tooltip.add(String.format("Tameable Can Ride: %s", ItemChair.isTameableCanRide(stack)));
            tooltip.add(String.format("Is No Gravity: %s", ItemChair.isNoGravity(stack)));
        }
    }

    static enum NBT {
        MODEL_ID("ModelId"),
        MOUNTED_HEIGHT("MountedHeight"),
        TAMEABLE_CAN_RIDE("TameableCanRide"),
        IS_NO_GRAVITY("IsNoGravity");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

