/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPhoto;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemChisel
extends Item {
    public ItemChisel() {
        this.func_77655_b("touhou_little_maid.chisel");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
        this.func_77656_e(64);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            if (worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150435_aG) {
                if (!worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.chisel.hit_block_error", new Object[0]));
                }
                return EnumActionResult.PASS;
            }
            if (player.func_184592_cb().func_77973_b() != MaidItems.PHOTO) {
                if (!worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.chisel.offhand_not_photo", new Object[0]));
                }
                return EnumActionResult.PASS;
            }
            this.genStatueBlocks(player, worldIn, pos, facing);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void genStatueBlocks(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        NBTTagCompound data = ItemPhoto.getMaidNbtData(player.func_184592_cb());
        TileEntityStatue.Size[] sizes = TileEntityStatue.Size.values();
        for (int i = sizes.length - 1; i >= 0; --i) {
            TileEntityStatue.Size size = sizes[i];
            Vec3i dimension = size.getDimension();
            Object[] posList = this.checkBlocks(worldIn, pos, dimension, facing);
            if (posList == null) continue;
            for (BlockPos blockPos : posList) {
                worldIn.func_175656_a(blockPos, MaidBlocks.STATUE.func_176223_P());
                TileEntity te = worldIn.func_175625_s(blockPos);
                if (!(te instanceof TileEntityStatue)) continue;
                TileEntityStatue statue = (TileEntityStatue)te;
                if (blockPos == pos) {
                    statue.setForgeData(size, true, pos, facing, Lists.newArrayList((Object[])posList), data);
                    continue;
                }
                statue.setForgeData(size, false, pos, facing, Lists.newArrayList((Object[])posList), null);
            }
            player.func_184614_ca().func_77972_a(size.ordinal() + 1, (EntityLivingBase)player);
            player.func_184185_a(SoundEvents.field_187689_f, 0.5f, 1.5f);
            return;
        }
    }

    @Nullable
    private BlockPos[] checkBlocks(@Nonnull World worldIn, BlockPos origin, Vec3i dimension, EnumFacing facing) {
        BlockPos[] posList = new BlockPos[dimension.func_177958_n() * dimension.func_177956_o() * dimension.func_177952_p()];
        int index = 0;
        for (int x = 0; x < dimension.func_177958_n(); ++x) {
            for (int y = 0; y < dimension.func_177956_o(); ++y) {
                for (int z = 0; z < dimension.func_177952_p(); ++z) {
                    BlockPos pos;
                    switch (facing) {
                        case WEST: {
                            pos = origin.func_177971_a(new Vec3i(x, y, z));
                            break;
                        }
                        case SOUTH: {
                            pos = origin.func_177971_a(new Vec3i(x, y, -z));
                            break;
                        }
                        default: {
                            pos = origin.func_177971_a(new Vec3i(-x, y, z));
                            break;
                        }
                        case EAST: {
                            pos = origin.func_177971_a(new Vec3i(-x, y, -z));
                        }
                    }
                    posList[index] = pos;
                    ++index;
                    if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150435_aG) continue;
                    return null;
                }
            }
        }
        return posList;
    }
}

