/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDebugDanmaku
extends Item {
    private static final String TYPE_TAG_NAME = "DanmakuType";
    private static final Random RANDOM = new Random();

    public ItemDebugDanmaku() {
        this.func_77655_b("touhou_little_maid.debug_danmaku");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    private static void addType(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o()) {
            tag = stack.func_77978_p();
            if (tag.func_74764_b(TYPE_TAG_NAME)) {
                tag.func_74768_a(TYPE_TAG_NAME, (tag.func_74762_e(TYPE_TAG_NAME) + 1) % DanmakuType.values().length);
            } else {
                tag.func_74768_a(TYPE_TAG_NAME, 0);
            }
        } else {
            tag = new NBTTagCompound();
            tag.func_74768_a(TYPE_TAG_NAME, 0);
        }
        stack.func_77982_d(tag);
    }

    private static DanmakuType getType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TYPE_TAG_NAME)) {
            int index = stack.func_77978_p().func_74762_e(TYPE_TAG_NAME);
            return DanmakuType.getType(index);
        }
        return DanmakuType.PELLET;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((Item)this);
        ItemDebugDanmaku.addType(stack);
        if (this.func_194125_a(tab)) {
            items.add((Object)stack);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (handIn == EnumHand.MAIN_HAND) {
            ItemStack stack = playerIn.func_184614_ca();
            if (playerIn.func_70093_af()) {
                ItemDebugDanmaku.addType(stack);
                if (!worldIn.field_72995_K) {
                    String typeKey = String.format("danmaku_type.touhou_little_maid.%s", ItemDebugDanmaku.getType(stack).name().toLowerCase(Locale.US));
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.debug_danmaku.type", new Object[]{new TextComponentTranslation(typeKey, new Object[0])}), true);
                }
            } else {
                DanmakuType type = ItemDebugDanmaku.getType(stack);
                DanmakuColor color = DanmakuColor.getColor(RANDOM.nextInt(DanmakuColor.getLength() + 1));
                if (!worldIn.field_72995_K) {
                    this.shootDanmaku(worldIn, playerIn, type, color);
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void shootDanmaku(World world, EntityPlayer player, DanmakuType type, DanmakuColor color) {
        Vec3d v = player.func_70040_Z();
        EntityDanmaku danmaku = new EntityDanmaku(world, (EntityLivingBase)player, 2.0f, 0.0f, type, color);
        danmaku.func_70107_b(danmaku.field_70165_t + v.field_72450_a, danmaku.field_70163_u + v.field_72448_b, danmaku.field_70161_v + v.field_72449_c);
        danmaku.func_70186_c(v.field_72450_a, v.field_72448_b, v.field_72449_c, 0.2f, 0.0f);
        world.func_72838_d((Entity)danmaku);
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187797_fA, player.func_184176_by(), 1.0f, 0.8f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.debug_danmaku.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"message.touhou_little_maid.debug_danmaku.type", (Object[])new Object[]{I18n.func_135052_a((String)String.format("danmaku_type.touhou_little_maid.%s", ItemDebugDanmaku.getType(stack).name().toLowerCase(Locale.US)), (Object[])new Object[0])}));
    }
}

