/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHammer
extends Item {
    private static final String STORE_BLOCK_POS_TAG = "StoreBlockPos";

    public ItemHammer() {
        this.func_77655_b("touhou_little_maid.hammer");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    public static void setStoreBlockPos(ItemStack hammer, BlockPos pos) {
        NBTTagCompound tag = hammer.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74782_a(STORE_BLOCK_POS_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        hammer.func_77982_d(tag);
    }

    @Nullable
    public static BlockPos getStoreBlockPos(ItemStack hammer) {
        if (hammer.func_77973_b() != MaidItems.HAMMER) {
            return null;
        }
        NBTTagCompound tag = hammer.func_77978_p();
        if (tag == null) {
            return null;
        }
        NBTTagCompound posTag = tag.func_74775_l(STORE_BLOCK_POS_TAG);
        return NBTUtil.func_186861_c((NBTTagCompound)posTag);
    }

    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemHammer.setStoreBlockPos(player.func_184614_ca(), pos);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.hammer.desc", (Object[])new Object[0]));
        BlockPos pos = ItemHammer.getStoreBlockPos(stack);
        if (pos == null) {
            tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.hammer.binding_pos.none", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.hammer.binding_pos.has", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
    }
}

