/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.compass.GuiKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemKappaCompass
extends Item {
    public static final int MAX_DISTANCE = 16;
    public static final int MAX_POINT_NUM = 9;
    private static final String POS_TAG_NAME = "CompassPosList";
    private static final String MODE_TAG_NAME = "CompassMode";

    public ItemKappaCompass() {
        this.func_77655_b("touhou_little_maid.kappa_compass");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    public static void setMode(ItemStack stack, Mode mode) {
        NBTTagCompound compound = new NBTTagCompound();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a(MODE_TAG_NAME, mode.ordinal());
        stack.func_77982_d(compound);
    }

    public static Mode getMode(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(MODE_TAG_NAME, 3)) {
            return Mode.getModeByIndex(stack.func_77978_p().func_74762_e(MODE_TAG_NAME));
        }
        return Mode.NONE;
    }

    @Nonnull
    public static List<BlockPos> getPos(ItemStack stack) {
        ArrayList blockPosList = Lists.newArrayList();
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(POS_TAG_NAME, 9)) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c(POS_TAG_NAME, 10);
            for (NBTBase compound : tagList) {
                blockPosList.add(NBTUtil.func_186861_c((NBTTagCompound)((NBTTagCompound)compound)));
            }
        }
        return blockPosList;
    }

    public static Result setPos(ItemStack stack, BlockPos posIn) {
        BlockPos lastPos;
        List<BlockPos> blockPosList = ItemKappaCompass.getPos(stack);
        if (blockPosList.size() >= 9) {
            return Result.FULL;
        }
        if (blockPosList.contains(posIn)) {
            return Result.DUPLICATE;
        }
        if (blockPosList.size() > 0 && (lastPos = blockPosList.get(blockPosList.size() - 1)).func_177951_i((Vec3i)posIn) > Math.pow(16.0, 2.0)) {
            return Result.TOO_FAR;
        }
        blockPosList.add(posIn);
        NBTTagCompound compound = new NBTTagCompound();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        NBTTagList tagList = new NBTTagList();
        for (BlockPos pos : blockPosList) {
            tagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a(POS_TAG_NAME, (NBTBase)tagList);
        stack.func_77982_d(compound);
        return Result.SUCCESS;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (worldIn.field_72995_K && handIn == EnumHand.MAIN_HAND) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiKappaCompass(playerIn.func_184614_ca()));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() == this) {
            ItemStack stack = player.func_184586_b(hand);
            if (player.func_70093_af()) {
                this.removePos(stack);
                if (!worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.kappa_compass.usage.result.clear", new Object[0]));
                }
            } else {
                Result result = this.setPosAndSendMessage(pos, facing, stack);
                if (result != Result.SUCCESS) {
                    if (!worldIn.field_72995_K) {
                        String message = String.format("message.touhou_little_maid.kappa_compass.usage.result.%s", result.name().toLowerCase(Locale.US));
                        player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
                    }
                } else {
                    player.func_184185_a(MaidSoundEvent.COMPASS_POINT, 0.8f, 1.5f);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private Result setPosAndSendMessage(BlockPos pos, EnumFacing facing, ItemStack stack) {
        Result result;
        Mode mode = ItemKappaCompass.getMode(stack);
        switch (mode) {
            default: {
                this.removePos(stack);
                result = ItemKappaCompass.setPos(stack, pos.func_177972_a(facing));
                ItemKappaCompass.setMode(stack, Mode.SINGLE_POINT);
                break;
            }
            case SINGLE_POINT: {
                this.removePos(stack);
                result = ItemKappaCompass.setPos(stack, pos.func_177972_a(facing));
                break;
            }
            case MULTI_POINT_REENTRY: 
            case MULTI_POINT_CLOSURE: {
                result = ItemKappaCompass.setPos(stack, pos.func_177972_a(facing));
                break;
            }
            case SET_RANGE: {
                List<BlockPos> posList = ItemKappaCompass.getPos(stack);
                result = posList.size() >= 2 ? Result.FULL : ItemKappaCompass.setPos(stack, pos.func_177972_a(facing));
            }
        }
        return result;
    }

    private void removePos(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(POS_TAG_NAME, 9)) {
            stack.func_77978_p().func_82580_o(POS_TAG_NAME);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String modeKey = String.format("compass.touhou_little_maid.mode.%s", ItemKappaCompass.getMode(stack).name().toLowerCase(Locale.US));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.kappa_compass.mode", (Object[])new Object[]{I18n.func_135052_a((String)modeKey, (Object[])new Object[0])}));
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.kappa_compass.usage.desc.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.kappa_compass.usage.desc.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.kappa_compass.usage.desc.3", (Object[])new Object[0]));
    }

    public static enum Result {
        SUCCESS,
        DUPLICATE,
        TOO_FAR,
        FULL;

    }

    public static enum Mode {
        SINGLE_POINT,
        MULTI_POINT_REENTRY,
        MULTI_POINT_CLOSURE,
        SET_RANGE,
        NONE;


        public static Mode getModeByIndex(int index) {
            return Mode.values()[MathHelper.func_76125_a((int)index, (int)0, (int)(Mode.values().length - 1))];
        }
    }
}

