/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMaidBackpack
extends Item {
    public ItemMaidBackpack() {
        this.func_77655_b("touhou_little_maid.maid_backpack");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
        this.func_77627_a(true);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EntityMaid.EnumBackPackLevel level : EntityMaid.EnumBackPackLevel.values()) {
                if (level == EntityMaid.EnumBackPackLevel.EMPTY) continue;
                items.add((Object)new ItemStack((Item)this, 1, level.getLevel()));
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)target;
            EntityMaid.EnumBackPackLevel level = maid.getBackLevel();
            if (stack.func_77973_b() == this && maid.func_184753_b() != null && maid.func_184753_b().equals(playerIn.func_110124_au())) {
                switch (level) {
                    case EMPTY: 
                    case SMALL: 
                    case MIDDLE: {
                        EntityMaid.EnumBackPackLevel needLevel = EntityMaid.EnumBackPackLevel.getEnumLevelByNum(level.getLevel() + 1);
                        EntityMaid.EnumBackPackLevel itemLevel = EntityMaid.EnumBackPackLevel.getEnumLevelByNum(stack.func_77960_j());
                        if (itemLevel == needLevel) {
                            maid.setBackpackLevel(EntityMaid.EnumBackPackLevel.getEnumLevelByNum(stack.func_77960_j()));
                            stack.func_190918_g(1);
                            break;
                        }
                        if (!playerIn.field_70170_p.field_72995_K) break;
                        TextComponentTranslation needLevelText = new TextComponentTranslation(String.format("message.touhou_little_maid.maid_backpack.%s", needLevel.name().toLowerCase(Locale.US)), new Object[0]);
                        TextComponentTranslation itemLevelText = new TextComponentTranslation(String.format("message.touhou_little_maid.maid_backpack.%s", itemLevel.name().toLowerCase(Locale.US)), new Object[0]);
                        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.maid_backpack.level_not_match", new Object[]{needLevelText, itemLevelText}));
                        break;
                    }
                    default: {
                        if (!playerIn.field_70170_p.field_72995_K) break;
                        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.maid_backpack.level_is_biggest", new Object[0]));
                    }
                }
                return true;
            }
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        EntityMaid.EnumBackPackLevel level = EntityMaid.EnumBackPackLevel.getEnumLevelByNum(stack.func_77960_j());
        switch (level) {
            case SMALL: 
            case MIDDLE: 
            case BIG: {
                tooltip.add(I18n.func_135052_a((String)String.format("message.touhou_little_maid.maid_backpack.%s", level.name().toLowerCase(Locale.US)), (Object[])new Object[0]));
                return;
            }
        }
    }
}

