/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidJoy;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.favorability.JoyType;
import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidJoy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMaidJoy
extends Item {
    private static final String TYPE_TAG_NAME = "MaidJoyType";

    public ItemMaidJoy() {
        this.func_77655_b("touhou_little_maid.maid_joy");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    public static ItemStack setType(ItemStack stack, String type) {
        NBTTagCompound tagCompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        tagCompound.func_74778_a(TYPE_TAG_NAME, type);
        stack.func_77982_d(tagCompound);
        return stack;
    }

    public static String getType(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (stack.func_77942_o() && (tagCompound = stack.func_77978_p()).func_150297_b(TYPE_TAG_NAME, 8)) {
            return tagCompound.func_74779_i(TYPE_TAG_NAME);
        }
        return "reading";
    }

    public String func_77653_i(ItemStack stack) {
        String key = String.format("item.touhou_little_maid.maid_joy.%s.name", ItemMaidJoy.getType(stack));
        return I18n.func_74838_a((String)key);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (String joyType : JoyType.JOYS.keySet()) {
                items.add((Object)ItemMaidJoy.setType(new ItemStack((Item)this), joyType));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState posBlockState = worldIn.func_180495_p(pos);
        Block block = posBlockState.func_177230_c();
        boolean replaceable = block.func_176200_f((IBlockAccess)worldIn, pos);
        if (!replaceable) {
            pos = pos.func_177984_a();
        }
        int index = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing playerFacing = EnumFacing.func_176731_b((int)index);
        ItemStack itemstack = player.func_184586_b(hand);
        JoyType type = JoyType.JOYS.get(ItemMaidJoy.getType(itemstack));
        BlockPos[] posList = type.getPosList(playerFacing);
        ArrayList absolutePosList = Lists.newArrayList();
        for (BlockPos p : posList) {
            BlockPos posIn = pos.func_177971_a((Vec3i)p);
            absolutePosList.add(posIn);
            IBlockState state = worldIn.func_180495_p(posIn);
            boolean blockIsOkay = state.func_177230_c().func_176200_f((IBlockAccess)worldIn, posIn) || worldIn.func_175623_d(posIn);
            boolean playerCanEdit = player.func_175151_a(pos, facing, itemstack);
            if (playerCanEdit && blockIsOkay) continue;
            return EnumActionResult.FAIL;
        }
        for (BlockPos p : absolutePosList) {
            TileEntityMaidJoy te;
            IBlockState maidJoy = MaidBlocks.MAID_JOY.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)playerFacing).func_177226_a((IProperty)BlockMaidJoy.CORE, (Comparable)Boolean.valueOf(p.equals((Object)pos)));
            worldIn.func_180501_a(p, maidJoy, 10);
            if (!(worldIn.func_175625_s(p) instanceof TileEntityMaidJoy) || (te = (TileEntityMaidJoy)worldIn.func_175625_s(p)) == null) continue;
            te.setForgeData(type.getName(), p.equals((Object)pos), pos, absolutePosList);
        }
        SoundType soundtype = SoundType.field_185848_a;
        worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        itemstack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }
}

