/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.draw.DrawManger;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemMaidModelCoupon
extends Item {
    private static final String MODEL_DATA_TAG = "com.github.tartaricacid.touhoulittlemaid.client.resources.ModelData";

    public ItemMaidModelCoupon() {
        this.func_77655_b("touhou_little_maid.maid_model_coupon");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MODEL_COUPON_TABS);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean hasModelData(ItemStack coupon) {
        if (coupon.func_77973_b() == MaidItems.MAID_MODEL_COUPON && coupon.func_77942_o()) {
            NBTTagCompound tag = coupon.func_77978_p();
            return tag != null && tag.func_150297_b(MODEL_DATA_TAG, 8);
        }
        return false;
    }

    public static ItemStack setModelData(ItemStack coupon, String modelId) {
        NBTTagCompound tag = coupon.func_77942_o() ? coupon.func_77978_p() : new NBTTagCompound();
        if (tag != null && StringUtils.isNotBlank((CharSequence)modelId)) {
            tag.func_74778_a(MODEL_DATA_TAG, modelId);
            coupon.func_77982_d(tag);
        }
        return coupon;
    }

    public static String getModelData(ItemStack coupon) {
        NBTTagCompound tag;
        if (coupon.func_77942_o() && (tag = coupon.func_77978_p()) != null && tag.func_150297_b(MODEL_DATA_TAG, 8)) {
            return tag.func_74779_i(MODEL_DATA_TAG);
        }
        return "touhou_little_maid:hakurei_reimu";
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && GeneralConfig.MAID_CONFIG.maidCannotChangeModel) {
            for (String modelId : DrawManger.getModelIdSet()) {
                ItemStack stack = new ItemStack((Item)this, 1, DrawManger.getModelLevel(modelId));
                items.add((Object)ItemMaidModelCoupon.setModelData(stack, modelId));
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof AbstractEntityMaid) {
            boolean modelIdNotSame;
            AbstractEntityMaid maid = (AbstractEntityMaid)event.getTarget();
            ItemStack stack = event.getItemStack();
            boolean isYourMaid = maid.func_184753_b() != null && maid.func_184753_b().equals(event.getEntityPlayer().func_110124_au());
            boolean stackIsRight = stack.func_77973_b() == MaidItems.MAID_MODEL_COUPON && ItemMaidModelCoupon.hasModelData(stack);
            boolean bl = modelIdNotSame = !ItemMaidModelCoupon.getModelData(stack).equals(maid.getModelId());
            if (isYourMaid && stackIsRight && modelIdNotSame) {
                maid.setModelId(ItemMaidModelCoupon.getModelData(stack));
                stack.func_190918_g(1);
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77960_j() > 3) {
            return true;
        }
        return super.func_77636_d(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (CustomResourcesLoader.MAID_MODEL.getInfo(ItemMaidModelCoupon.getModelData(stack)).isPresent()) {
            tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.maid_model_coupon.desc", (Object[])new Object[]{ParseI18n.parse(CustomResourcesLoader.MAID_MODEL.getInfo(ItemMaidModelCoupon.getModelData(stack)).get().getName())}));
        }
        String star = DrawManger.Level.getFormatTextByIndex(stack.func_77960_j());
        tooltip.add(star);
    }
}

