/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPhoto
extends Item {
    public ItemPhoto() {
        this.func_77655_b("touhou_little_maid.photo");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    static EnumActionResult onPhotoUse(EntityPlayer player, World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, ItemStack photo) {
        if (facing != EnumFacing.UP || PlaceHelper.notSuitableForPlaceMaid(worldIn, pos)) {
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.photo.not_suitable_for_place_maid", new Object[0]));
            }
            return EnumActionResult.FAIL;
        }
        if (photo.func_77978_p() == null || photo.func_77978_p().func_74775_l(NBT.MAID_INFO.getNbtName()).func_82582_d()) {
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.photo.have_no_nbt_data", new Object[0]));
            }
            return EnumActionResult.FAIL;
        }
        EntityMaid maid = new EntityMaid(worldIn);
        maid.func_70037_a(photo.func_77978_p().func_74775_l(NBT.MAID_INFO.getNbtName()));
        maid.func_70107_b((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        if (photo.func_82837_s()) {
            maid.func_96094_a(photo.func_82833_r());
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)maid);
        }
        maid.func_70656_aK();
        photo.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public static boolean hasMaidNbtData(ItemStack stack) {
        return stack.func_77942_o() && !Objects.requireNonNull(stack.func_77978_p()).func_74775_l(NBT.MAID_INFO.getNbtName()).func_82582_d();
    }

    public static NBTTagCompound getMaidNbtData(ItemStack stack) {
        if (ItemPhoto.hasMaidNbtData(stack)) {
            return Objects.requireNonNull(stack.func_77978_p()).func_74775_l(NBT.MAID_INFO.getNbtName());
        }
        return new NBTTagCompound();
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemPhoto.onPhotoUse(player, worldIn, pos, facing, hitX, hitY, hitZ, player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemPhoto.hasMaidNbtData(stack)) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltips.touhou_little_maid.photo.no_data.desc", (Object[])new Object[0]));
        } else {
            String modelId = stack.func_77978_p().func_74775_l(NBT.MAID_INFO.getNbtName()).func_74779_i(EntityMaid.NBT.MODEL_ID.getName());
            if (!"".equals(modelId)) {
                CustomResourcesLoader.MAID_MODEL.getInfo(modelId).ifPresent(modelItem -> tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.photo.maid.desc", (Object[])new Object[]{ParseI18n.parse(modelItem.getName())})));
            }
        }
        if (flagIn.func_194127_a() && GuiScreen.func_146272_n() && stack.func_77942_o()) {
            tooltip.add(Objects.requireNonNull(stack.func_77978_p()).toString());
        }
    }

    static enum NBT {
        MAID_INFO("MaidInfo");

        private String nbtName;

        private NBT(String nbtName) {
            this.nbtName = nbtName;
        }

        public String getNbtName() {
            return this.nbtName;
        }
    }
}

