/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class ItemPotionGuide
extends Item {
    public static final int GUIDE_INV_SIZE = 6;
    public static final String GUIDE_INV_TAG = "PotionGuideInv";
    public static final String GUIDE_INDEX_TAG = "PotionIndex";
    public static final String GUIDE_POS_TAG = "BrewingStandPos";

    public ItemPotionGuide() {
        this.func_77655_b("touhou_little_maid.potion_guide");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    public static ItemStackHandler getGuideInv(ItemStack guide) {
        NBTTagCompound tag;
        PotionGuideItemStackHandler handler = new PotionGuideItemStackHandler(6);
        if (guide.func_77973_b() instanceof ItemPotionGuide && (tag = guide.func_77978_p()) != null && tag.func_150297_b(GUIDE_INV_TAG, 10)) {
            NBTTagCompound tagInv = tag.func_74775_l(GUIDE_INV_TAG);
            handler.deserializeNBT(tagInv);
        }
        return handler;
    }

    public static void setGuideInv(ItemStack guide, ItemStackHandler itemStackHandler) {
        if (guide.func_77973_b() instanceof ItemPotionGuide) {
            NBTTagCompound tag = guide.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74782_a(GUIDE_INV_TAG, (NBTBase)itemStackHandler.serializeNBT());
            guide.func_77982_d(tag);
        }
    }

    public static int getGuideIndex(ItemStack guide) {
        NBTTagCompound tag;
        if (guide.func_77973_b() instanceof ItemPotionGuide && (tag = guide.func_77978_p()) != null && tag.func_150297_b(GUIDE_INDEX_TAG, 3)) {
            return tag.func_74762_e(GUIDE_INDEX_TAG);
        }
        return 0;
    }

    public static void setGuideIndex(ItemStack guide, int index) {
        if (guide.func_77973_b() instanceof ItemPotionGuide) {
            NBTTagCompound tag = guide.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a(GUIDE_INDEX_TAG, MathHelper.func_76125_a((int)index, (int)0, (int)5));
            guide.func_77982_d(tag);
        }
    }

    @Nullable
    public static BlockPos getGuidePos(ItemStack guide) {
        NBTTagCompound tag;
        if (guide.func_77973_b() instanceof ItemPotionGuide && (tag = guide.func_77978_p()) != null && tag.func_150297_b(GUIDE_POS_TAG, 10)) {
            return NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l(GUIDE_POS_TAG));
        }
        return null;
    }

    public static void setGuidePos(ItemStack guide, BlockPos pos) {
        if (guide.func_77973_b() instanceof ItemPotionGuide) {
            NBTTagCompound tag = guide.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74782_a(GUIDE_POS_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            guide.func_77982_d(tag);
        }
    }

    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn == EnumHand.MAIN_HAND && playerIn.func_184586_b(handIn).func_77973_b() instanceof ItemPotionGuide) {
            playerIn.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.POTION_GUIDE.getId(), worldIn, 0, 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemStackHandler handler = ItemPotionGuide.getGuideInv(stack);
        boolean hasItem = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            hasItem = true;
        }
        if (hasItem) {
            tooltip.add("                        ");
            tooltip.add("                        ");
        }
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.potion_guide.desc", (Object[])new Object[0]));
    }

    private static class PotionGuideItemStackHandler
    extends ItemStackHandler {
        private PotionGuideItemStackHandler(int size) {
            super(size);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

