/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityScarecrow;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScarecrow
extends Item {
    public ItemScarecrow() {
        this.func_77655_b("touhou_little_maid.scarecrow");
        this.func_77625_d(8);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        boolean replaceable = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
        BlockPos posOffset = replaceable ? pos : pos.func_177972_a(facing);
        if (!player.func_175151_a(posOffset, facing, stack = player.func_184614_ca())) {
            return EnumActionResult.FAIL;
        }
        return this.checkPosition(player, worldIn, pos, posOffset, stack);
    }

    private EnumActionResult checkPosition(EntityPlayer player, World worldIn, BlockPos pos, BlockPos posOffset, ItemStack stack) {
        BlockPos posUp = posOffset.func_177984_a();
        boolean cannotPlace = !worldIn.func_175623_d(posOffset) && !worldIn.func_180495_p(posOffset).func_177230_c().func_176200_f((IBlockAccess)worldIn, posOffset);
        if (cannotPlace |= !worldIn.func_175623_d(posUp) && !worldIn.func_180495_p(posUp).func_177230_c().func_176200_f((IBlockAccess)worldIn, posUp)) {
            return EnumActionResult.FAIL;
        }
        return this.checkAABBEntity(player, worldIn, pos, posOffset, stack);
    }

    private EnumActionResult checkAABBEntity(EntityPlayer player, World worldIn, BlockPos pos, BlockPos posOffset, ItemStack stack) {
        double z;
        double y;
        double x = posOffset.func_177958_n();
        List entityList = worldIn.func_72839_b(null, new AxisAlignedBB(x, y = (double)posOffset.func_177956_o(), z = (double)posOffset.func_177952_p(), x + 1.0, y + 2.0, z + 1.0));
        if (!entityList.isEmpty()) {
            return EnumActionResult.FAIL;
        }
        this.spawnScarecrowEntity(player, worldIn, pos, stack, x, y, z);
        return EnumActionResult.SUCCESS;
    }

    private void spawnScarecrowEntity(EntityPlayer player, World worldIn, BlockPos pos, ItemStack stack, double x, double y, double z) {
        float yaw = (float)MathHelper.func_76141_d((float)((MathHelper.func_76142_g((float)(player.field_70177_z - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
        EntityScarecrow scarecrow = new EntityScarecrow(worldIn, x + 0.5, y, z + 0.5, yaw);
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound.func_150297_b("ScarecrowCustomName", 8)) {
                scarecrow.func_96094_a(compound.func_74779_i("ScarecrowCustomName"));
            }
            if (compound.func_150297_b("ScarecrowText", 8)) {
                scarecrow.setText(compound.func_74779_i("ScarecrowText"));
            }
            if (compound.func_150297_b("ScarecrowSpecial", 1)) {
                scarecrow.setSpecial(compound.func_74767_n("ScarecrowSpecial"));
            }
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)scarecrow);
            worldIn.func_184148_a(null, scarecrow.field_70165_t, scarecrow.field_70163_u, scarecrow.field_70161_v, SoundEvents.field_187710_m, SoundCategory.BLOCKS, 0.75f, 0.8f);
        }
        scarecrow.field_70759_as = yaw;
        stack.func_190918_g(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.chair.place.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.chair.destroy.desc", (Object[])new Object[0]));
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && !compound.func_82582_d()) {
            if (compound.func_150297_b("ScarecrowCustomName", 8)) {
                tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.scarecrow.name", (Object[])new Object[]{compound.func_74779_i("ScarecrowCustomName")}));
            }
            if (compound.func_150297_b("ScarecrowText", 8)) {
                tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.scarecrow.text", (Object[])new Object[]{compound.func_74779_i("ScarecrowText")}));
            }
            if (compound.func_150297_b("ScarecrowSpecial", 1)) {
                tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.scarecrow.special", (Object[])new Object[0]));
            }
        }
    }
}

