/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumSerializer;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSmartSlab
extends Item {
    public static final String MAID_INFO_TAG = "StoreMaidInfo";

    public ItemSmartSlab() {
        this.func_77655_b("touhou_little_maid.smart_slab");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
        this.func_77627_a(true);
    }

    public static boolean hasMaidNbtData(ItemStack stack) {
        return stack.func_77942_o() && !Objects.requireNonNull(stack.func_77978_p()).func_74775_l(MAID_INFO_TAG).func_82582_d();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack slab = player.func_184586_b(hand);
        if (slab.func_77960_j() == 1) {
            return EnumActionResult.PASS;
        }
        if (facing != EnumFacing.UP || PlaceHelper.notSuitableForPlaceMaid(worldIn, pos)) {
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.photo.not_suitable_for_place_maid", new Object[0]));
            }
            return EnumActionResult.FAIL;
        }
        MaidNumHandler num = (MaidNumHandler)player.getCapability(MaidNumSerializer.MAID_NUM_CAP, null);
        if (slab.func_77960_j() == 0 && num != null && num.canAdd()) {
            num.add();
            EntityMaid maid = new EntityMaid(worldIn);
            maid.func_193101_c(player);
            maid.func_70107_b((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
            maid.func_180482_a(worldIn.func_175649_E(pos), null);
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)maid);
            }
            maid.func_70656_aK();
            this.setDamage(slab, 1);
            maid.func_184185_a(SoundEvents.field_187806_ee, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            return EnumActionResult.SUCCESS;
        }
        if (slab.func_77960_j() == 2) {
            if (slab.func_77978_p() == null || slab.func_77978_p().func_74775_l(MAID_INFO_TAG).func_82582_d()) {
                if (worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.photo.have_no_nbt_data", new Object[0]));
                }
                return EnumActionResult.FAIL;
            }
            EntityMaid maid = new EntityMaid(worldIn);
            maid.func_70037_a(slab.func_77978_p().func_74775_l(MAID_INFO_TAG));
            maid.func_70107_b((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
            if (slab.func_82837_s()) {
                maid.func_96094_a(slab.func_82833_r());
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)maid);
            }
            maid.func_70656_aK();
            this.setDamage(slab, 1);
            maid.func_184185_a(SoundEvents.field_187806_ee, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77960_j() != 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String modelId;
        if (stack.func_77960_j() == 0) {
            String text = I18n.func_135052_a((String)"tooltips.touhou_little_maid.smart_slab.maid_name", (Object[])new Object[]{I18n.func_135052_a((String)"tooltips.touhou_little_maid.smart_slab.maid_name.unknow", (Object[])new Object[0])});
            tooltip.add(text);
        }
        if (stack.func_77960_j() == 2 && !"".equals(modelId = stack.func_77978_p().func_74775_l(MAID_INFO_TAG).func_74779_i(EntityMaid.NBT.MODEL_ID.getName()))) {
            CustomResourcesLoader.MAID_MODEL.getInfo(modelId).ifPresent(modelItem -> tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.smart_slab.maid_name", (Object[])new Object[]{ParseI18n.parse(modelItem.getName())})));
        }
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.smart_slab.desc", (Object[])new Object[0]));
    }
}

