/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardEntry;
import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardManger;
import com.github.tartaricacid.touhoulittlemaid.danmaku.script.EntityLivingBaseWrapper;
import com.github.tartaricacid.touhoulittlemaid.danmaku.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Invocable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpellCard
extends Item {
    private static final String SPELL_CARD_ENTRY_TAG = "SpellCardEntry";

    public ItemSpellCard() {
        this.func_77655_b("touhou_little_maid.spell_card");
        this.func_77625_d(1);
    }

    public static boolean useSpellCard(EntityLivingBase user, CustomSpellCardEntry entry) {
        try {
            if (entry == null) {
                return false;
            }
            Invocable invocable = (Invocable)((Object)CommonProxy.NASHORN);
            invocable.invokeMethod(entry.getScript(), "spellCard", new WorldWrapper(user.func_130014_f_()), new EntityLivingBaseWrapper(user));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ItemStack setCustomSpellCardEntry(String id, ItemStack spellCard) {
        if (spellCard.func_77973_b() == MaidItems.SPELL_CARD) {
            NBTTagCompound tag = spellCard.func_77942_o() ? spellCard.func_77978_p() : new NBTTagCompound();
            tag.func_74778_a(SPELL_CARD_ENTRY_TAG, id);
            spellCard.func_77982_d(tag);
        }
        return spellCard;
    }

    @Nullable
    public static CustomSpellCardEntry getCustomSpellCardEntry(ItemStack spellCard, @Nullable EntityLivingBase user) {
        String id;
        Map<String, CustomSpellCardEntry> map = user != null && user.field_70170_p.field_72995_K ? CustomSpellCardManger.CUSTOM_SPELL_CARD_CLIENT : CustomSpellCardManger.CUSTOM_SPELL_CARD_SERVER;
        if (map.isEmpty()) {
            return null;
        }
        CustomSpellCardEntry defaultEntry = map.values().stream().findFirst().get();
        if (spellCard.func_77973_b() == MaidItems.SPELL_CARD && spellCard.func_77942_o() && !(id = spellCard.func_77978_p().func_74779_i(SPELL_CARD_ENTRY_TAG)).isEmpty()) {
            return map.getOrDefault(id, defaultEntry);
        }
        return defaultEntry;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Set<String> ids = CustomSpellCardManger.CUSTOM_SPELL_CARD_CLIENT.keySet();
            for (String id : ids) {
                items.add((Object)ItemSpellCard.setCustomSpellCardEntry(id, new ItemStack((Item)this)));
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        CustomSpellCardEntry entry = ItemSpellCard.getCustomSpellCardEntry(stack, null);
        if (entry == null) {
            return "";
        }
        return TextFormatting.GOLD + I18n.func_74838_a((String)entry.getNameKey());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CustomSpellCardEntry entry = ItemSpellCard.getCustomSpellCardEntry(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        if (entry == null) {
            return;
        }
        if (!entry.getDescriptionKey().isEmpty()) {
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)entry.getDescriptionKey(), (Object[])new Object[0]));
        }
        if (!entry.getAuthor().isEmpty()) {
            tooltip.add("\u00a7a\u258d\u00a0\u00a77" + net.minecraft.client.resources.I18n.func_135052_a((String)"tooltips.touhou_little_maid.spell_card.author", (Object[])new Object[]{entry.getAuthor()}));
        }
        if (!entry.getVersion().isEmpty()) {
            tooltip.add("\u00a7a\u258d\u00a0\u00a77" + net.minecraft.client.resources.I18n.func_135052_a((String)"tooltips.touhou_little_maid.spell_card.version", (Object[])new Object[]{entry.getVersion()}));
        }
        tooltip.add("\u00a7a\u258d\u00a0\u00a77" + net.minecraft.client.resources.I18n.func_135052_a((String)"tooltips.touhou_little_maid.spell_card.cooldown", (Object[])new Object[]{entry.getCooldown()}));
    }
}

