/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class ItemWirelessIO
extends Item {
    private static final int FILTER_LIST_SIZE = 9;
    private static final String FILTER_LIST_TAG = "ItemFilterList";
    private static final String FILTER_MODE_TAG = "ItemFilterMode";
    private static final String IO_MODE_TAG = "ItemIOMode";
    private static final String BINDING_POS = "BindingPos";
    private static final String SLOT_CONFIG_TAG = "SlotConfigData";
    private static final String TOOLTIPS_PREFIX = "\u00a7a\u258d\u00a0\u00a77";

    public ItemWirelessIO() {
        this.func_77655_b("touhou_little_maid.wireless_io");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.MAIN_TABS);
    }

    public static void setIOMode(ItemStack stack, boolean isInput) {
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74757_a(IO_MODE_TAG, isInput);
            stack.func_77982_d(nbt);
        }
    }

    public static boolean isInputMode(ItemStack stack) {
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO && stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt.func_74767_n(IO_MODE_TAG);
        }
        return false;
    }

    public static void setFilterMode(ItemStack stack, boolean isBlacklist) {
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74757_a(FILTER_MODE_TAG, isBlacklist);
            stack.func_77982_d(nbt);
        }
    }

    public static boolean isBlacklist(ItemStack stack) {
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO && stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt.func_74767_n(FILTER_MODE_TAG);
        }
        return false;
    }

    public static ItemStackHandler getFilterList(ItemStack stack) {
        NBTTagCompound tag;
        WirelessIOHandler handler = new WirelessIOHandler(9);
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO && (tag = stack.func_77978_p()) != null && tag.func_150297_b(FILTER_LIST_TAG, 10)) {
            handler.deserializeNBT(tag.func_74775_l(FILTER_LIST_TAG));
        }
        return handler;
    }

    public static void setFilterList(ItemStack stack, ItemStackHandler itemStackHandler) {
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74782_a(FILTER_LIST_TAG, (NBTBase)itemStackHandler.serializeNBT());
            stack.func_77982_d(tag);
        }
    }

    @Nullable
    public static BlockPos getBindingPos(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO && (tag = stack.func_77978_p()) != null && tag.func_150297_b(BINDING_POS, 10)) {
            return NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l(BINDING_POS));
        }
        return null;
    }

    public static void setBindingPos(ItemStack stack, BlockPos pos) {
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74782_a(BINDING_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            stack.func_77982_d(tag);
        }
    }

    public static void setSlotConfig(ItemStack stack, byte[] config) {
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74782_a(SLOT_CONFIG_TAG, (NBTBase)new NBTTagByteArray(config));
            stack.func_77982_d(tag);
        }
    }

    @Nullable
    public static byte[] getSlotConfig(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == MaidItems.WIRELESS_IO && (tag = stack.func_77978_p()) != null && tag.func_150297_b(SLOT_CONFIG_TAG, 7)) {
            return tag.func_74770_j(SLOT_CONFIG_TAG);
        }
        return null;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            if (chest.func_174893_q_() && !player.func_175146_a(chest.func_174891_i()) && !player.func_175149_v()) {
                return EnumActionResult.FAIL;
            }
            if (hand == EnumHand.MAIN_HAND) {
                ItemStack stack = player.func_184614_ca();
                ItemWirelessIO.setBindingPos(stack, pos);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn == EnumHand.MAIN_HAND) {
            playerIn.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.WIRELESS_IO.getId(), worldIn, 0, 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean isInput = ItemWirelessIO.isInputMode(stack);
        boolean isBlacklist = ItemWirelessIO.isBlacklist(stack);
        BlockPos pos = ItemWirelessIO.getBindingPos(stack);
        String ioModeText = isInput ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.io_mode.input", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.io_mode.output", (Object[])new Object[0]);
        String filterModeText = isBlacklist ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.blacklist", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.whitelist", (Object[])new Object[0]);
        String hasPos = pos != null ? I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.has", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}) : I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.none", (Object[])new Object[0]);
        ItemStackHandler handler = ItemWirelessIO.getFilterList(stack);
        boolean hasItem = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            hasItem = true;
        }
        if (hasItem) {
            tooltip.add("                                    ");
            tooltip.add("                                    ");
        }
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.usage.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.wireless_io.usage.2", (Object[])new Object[0]));
        tooltip.add(TOOLTIPS_PREFIX + ioModeText);
        tooltip.add(TOOLTIPS_PREFIX + filterModeText);
        tooltip.add(TOOLTIPS_PREFIX + hasPos);
    }

    private static class WirelessIOHandler
    extends ItemStackHandler {
        private WirelessIOHandler(int size) {
            super(size);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

