/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.serverpack;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CustomModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.ServerPackTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resources.ModelData;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.EasterEgg;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Side.CLIENT})
public final class ClientPackManager {
    public static final List<Long> CRC32_LIST_FROM_SERVER = Lists.newArrayList();
    private static final Pattern DOMAIN = Pattern.compile("^assets/([\\w.]+)/$");
    private static final Path ROOT_FOLDER = Paths.get(System.getProperty("user.home"), new String[0]).resolve("touhou_little_maid").resolve("server_pack");
    private static final Map<Long, File> CRC32_FILE_MAP = Maps.newHashMap();
    private static final Logger LOGGER = TouhouLittleMaid.LOGGER;
    private static final Marker MARKER = MarkerManager.getMarker((String)"ClientPackManager");

    public static void initCrc32Info() {
        File[] files;
        CRC32_FILE_MAP.clear();
        File packFolder = ROOT_FOLDER.toFile();
        if (!packFolder.isDirectory()) {
            try {
                Files.createDirectories(packFolder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if ((files = packFolder.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            try {
                long crc32 = FileUtils.checksumCRC32((File)file);
                CRC32_FILE_MAP.put(crc32, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEnterClientWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!CRC32_LIST_FROM_SERVER.isEmpty()) {
            CRC32_LIST_FROM_SERVER.clear();
            CustomResourcesLoader.reloadResources();
        }
    }

    public static File storePackFile(byte[] data, long crc32) throws IOException {
        File file = ROOT_FOLDER.resolve(String.valueOf(crc32)).toFile();
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        return file;
    }

    public static void readModelFromZipFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                Matcher matcher = DOMAIN.matcher(iteration.nextElement().getName());
                if (!matcher.find()) continue;
                String domain = matcher.group(1);
                ClientPackManager.loadMaidModelPack(zipFile, domain);
                ClientPackManager.loadChairModelPack(zipFile, domain);
                ClientPackManager.readLanguageFile(zipFile, domain);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static void loadMaidModelPack(ZipFile zipFile, String domain) {
        LOGGER.info(MARKER, "Touhou little maid mod's model is loading...");
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", domain, CustomResourcesLoader.MAID_MODEL.getJsonFileName()));
        if (entry == null) {
            return;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            CustomModelPack pack = (CustomModelPack)CommonProxy.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<MaidModelInfo>>(){}.getType());
            pack.decorate();
            if (pack.getIcon() != null) {
                Minecraft.func_71410_x().field_71446_o.func_110579_a(pack.getIcon(), (ITextureObject)new ServerPackTexture(zipFile, pack.getIcon()));
            }
            for (MaidModelInfo maidModelItem : pack.getModelList()) {
                EntityModelJson modelJson = ClientPackManager.loadModel(zipFile, maidModelItem.getModel());
                Minecraft.func_71410_x().field_71446_o.func_110579_a(maidModelItem.getTexture(), (ITextureObject)new ServerPackTexture(zipFile, maidModelItem.getTexture()));
                List<Object> animations = CustomJsAnimationManger.getCustomAnimation(zipFile, maidModelItem);
                if (modelJson == null) continue;
                if (maidModelItem.getEasterEgg() != null && StringUtils.isNotBlank((CharSequence)maidModelItem.getEasterEgg().getTag())) {
                    ClientPackManager.putMaidEasterEggData(maidModelItem, modelJson, animations);
                } else {
                    ClientPackManager.putMaidModelData(maidModelItem, modelJson, animations);
                }
                LOGGER.info(MARKER, "Loaded model: {}", (Object)maidModelItem.getModel());
            }
            pack.getModelList().removeIf(maidModelInfo -> maidModelInfo.getEasterEgg() != null);
            CustomResourcesLoader.MAID_MODEL.addPack(pack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        LOGGER.info(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void putMaidEasterEggData(MaidModelInfo maidModelItem, EntityModelJson modelJson, List<Object> animations) {
        EasterEgg easterEgg = maidModelItem.getEasterEgg();
        ModelData data = new ModelData(modelJson, maidModelItem, animations);
        if (easterEgg.isEncrypt()) {
            CustomResourcesLoader.MAID_MODEL.putEasterEggEncryptTagModel(easterEgg.getTag(), data);
        } else {
            CustomResourcesLoader.MAID_MODEL.putEasterEggNormalTagModel(easterEgg.getTag(), data);
        }
    }

    private static void putMaidModelData(MaidModelInfo maidModelItem, EntityModelJson modelJson, List<Object> animations) {
        String id = maidModelItem.getModelId().toString();
        CustomResourcesLoader.MAID_MODEL.putModel(id, modelJson);
        CustomResourcesLoader.MAID_MODEL.putInfo(id, maidModelItem);
        if (animations != null && animations.size() > 0) {
            CustomResourcesLoader.MAID_MODEL.putAnimation(id, animations);
        }
    }

    private static void loadChairModelPack(ZipFile zipFile, String domain) {
        LOGGER.info(MARKER, "Touhou little maid mod's model is loading...");
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", domain, CustomResourcesLoader.CHAIR_MODEL.getJsonFileName()));
        if (entry == null) {
            return;
        }
        try (InputStream stream2 = zipFile.getInputStream(entry);){
            CustomModelPack pack = (CustomModelPack)CommonProxy.GSON.fromJson((Reader)new InputStreamReader(stream2, StandardCharsets.UTF_8), new TypeToken<CustomModelPack<ChairModelInfo>>(){}.getType());
            pack.decorate();
            if (pack.getIcon() != null) {
                Minecraft.func_71410_x().field_71446_o.func_110579_a(pack.getIcon(), (ITextureObject)new ServerPackTexture(zipFile, pack.getIcon()));
            }
            for (ChairModelInfo chairModelItem : pack.getModelList()) {
                EntityModelJson modelJson = ClientPackManager.loadModel(zipFile, chairModelItem.getModel());
                Minecraft.func_71410_x().field_71446_o.func_110579_a(chairModelItem.getTexture(), (ITextureObject)new ServerPackTexture(zipFile, chairModelItem.getTexture()));
                List<Object> animations = CustomJsAnimationManger.getCustomAnimation(zipFile, chairModelItem);
                if (modelJson == null) continue;
                String id = chairModelItem.getModelId().toString();
                CustomResourcesLoader.CHAIR_MODEL.putModel(id, modelJson);
                CustomResourcesLoader.CHAIR_MODEL.putInfo(id, chairModelItem);
                if (animations != null && animations.size() > 0) {
                    CustomResourcesLoader.CHAIR_MODEL.putAnimation(id, animations);
                }
                LOGGER.info(MARKER, "Loaded model: {}", (Object)chairModelItem.getModel());
            }
            CustomResourcesLoader.CHAIR_MODEL.addPack(pack);
        }
        catch (IOException stream2) {
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
            e.printStackTrace();
        }
        LOGGER.info(MARKER, "Touhou little maid mod's model is loaded");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static EntityModelJson loadModel(ZipFile zipFile, ResourceLocation modelLocation) {
        String path = String.format("assets/%s/%s", modelLocation.func_110624_b(), modelLocation.func_110623_a());
        ZipEntry entry = zipFile.getEntry(path);
        if (entry == null) {
            return null;
        }
        try (InputStream stream = zipFile.getInputStream(entry);){
            CustomModelPOJO pojo = (CustomModelPOJO)CommonProxy.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), CustomModelPOJO.class);
            if (pojo.getFormatVersion().equals(BedrockVersion.LEGACY.getVersion())) {
                if (pojo.getGeometryModel() != null) {
                    EntityModelJson entityModelJson = new EntityModelJson(pojo, BedrockVersion.LEGACY);
                    return entityModelJson;
                }
                LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
            }
            if (pojo.getFormatVersion().equals(BedrockVersion.NEW.getVersion())) {
                if (pojo.getGeometryModelNew() != null) {
                    EntityModelJson entityModelJson = new EntityModelJson(pojo, BedrockVersion.NEW);
                    return entityModelJson;
                }
                LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
                EntityModelJson entityModelJson = null;
                return entityModelJson;
            }
            LOGGER.warn(MARKER, "{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
            return null;
        }
        catch (IOException ioe) {
            LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
            ioe.printStackTrace();
        }
        return null;
    }

    private static void readLanguageFile(ZipFile zipFile, String domain) throws IOException {
        ZipEntry currentEntry;
        String english = String.format("assets/%s/lang/en_us.lang", domain);
        String current = String.format("assets/%s/lang/%s.lang", domain, Minecraft.func_71410_x().field_71474_y.field_74363_ab);
        ZipEntry englishEntry = zipFile.getEntry(english);
        if (englishEntry != null) {
            I18n.field_135054_a.func_135021_a(zipFile.getInputStream(englishEntry));
        }
        if (!current.equals(english) && (currentEntry = zipFile.getEntry(current)) != null) {
            I18n.field_135054_a.func_135021_a(zipFile.getInputStream(currentEntry));
        }
    }

    public static Map<Long, File> getCrc32FileMap() {
        return CRC32_FILE_MAP;
    }
}

