/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.serverpack;

import com.github.tartaricacid.touhoulittlemaid.network.serverpack.SendClientPackMessage;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.ServerPackManager;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.util.DelayedTask;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.FileUtils;

public class GetServerPackMessage
implements IMessage {
    private List<Long> needList = Lists.newArrayList();

    public GetServerPackMessage() {
    }

    public GetServerPackMessage(List<Long> needList) {
        this.needList = needList;
    }

    public void fromBytes(ByteBuf buf) {
        this.needList.clear();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.needList.add(buf.readLong());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.needList.size());
        for (long crc32 : this.needList) {
            buf.writeLong(crc32);
        }
    }

    public static class Handler
    implements IMessageHandler<GetServerPackMessage, IMessage> {
        private static void sendPack(GetServerPackMessage message, MessageContext ctx) {
            int delay = new Random().nextInt(100) + 50;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Iterator iterator = message.needList.iterator();
            while (iterator.hasNext()) {
                long crc32 = (Long)iterator.next();
                if (!ServerPackManager.getCrc32FileMap().containsKey(crc32)) continue;
                DelayedTask.add(() -> {
                    if (player != null) {
                        File file = ServerPackManager.getCrc32FileMap().get(crc32);
                        try {
                            byte[] data = FileUtils.readFileToByteArray((File)file);
                            CommonProxy.INSTANCE.sendTo((IMessage)new SendClientPackMessage(crc32, data, data.length), player);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }, delay);
                delay += 100;
            }
        }

        public IMessage onMessage(GetServerPackMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> Handler.sendPack(message, ctx));
            }
            return null;
        }
    }
}

