/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.serverpack;

import com.github.tartaricacid.touhoulittlemaid.network.serverpack.ClientPackManager;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.FileUtils;

public class SendClientPackMessage
implements IMessage {
    private long crc32;
    private byte[] data;
    private int length;

    public SendClientPackMessage() {
    }

    public SendClientPackMessage(long crc32, byte[] data, int length) {
        this.crc32 = crc32;
        this.data = data;
        this.length = length;
    }

    public void fromBytes(ByteBuf buf) {
        this.crc32 = buf.readLong();
        this.length = buf.readInt();
        this.data = new byte[this.length];
        buf.readBytes(this.data);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.crc32);
        buf.writeInt(this.data.length);
        buf.writeBytes(this.data);
    }

    public static class Handler
    implements IMessageHandler<SendClientPackMessage, IMessage> {
        public IMessage onMessage(SendClientPackMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    try {
                        File file = ClientPackManager.storePackFile(message.data, message.crc32);
                        if (FileUtils.checksumCRC32((File)file) == message.crc32) {
                            ClientPackManager.readModelFromZipFile(file);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            return null;
        }
    }
}

