/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.serverpack;

import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomResourcesLoader;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.ClientPackManager;
import com.github.tartaricacid.touhoulittlemaid.network.serverpack.GetServerPackMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SyncClientPackMessage
implements IMessage {
    private final List<Long> data = Lists.newArrayList();

    public SyncClientPackMessage() {
    }

    public SyncClientPackMessage(Map<Long, File> rawData) {
        this.data.addAll(rawData.keySet());
    }

    public void fromBytes(ByteBuf buf) {
        this.data.clear();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.data.add(buf.readLong());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.data.size());
        for (long crc32 : this.data) {
            buf.writeLong(crc32);
        }
    }

    public static class Handler
    implements IMessageHandler<SyncClientPackMessage, IMessage> {
        public IMessage onMessage(SyncClientPackMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientPackManager.initCrc32Info();
                    ClientPackManager.CRC32_LIST_FROM_SERVER.clear();
                    CustomResourcesLoader.reloadResources();
                    Set<Long> localFileCrc = ClientPackManager.getCrc32FileMap().keySet();
                    ArrayList need = Lists.newArrayList();
                    Iterator iterator = message.data.iterator();
                    while (iterator.hasNext()) {
                        long crc32 = (Long)iterator.next();
                        ClientPackManager.CRC32_LIST_FROM_SERVER.add(crc32);
                        if (!localFileCrc.contains(crc32)) {
                            need.add(crc32);
                            continue;
                        }
                        ClientPackManager.readModelFromZipFile(ClientPackManager.getCrc32FileMap().get(crc32));
                    }
                    if (need.size() > 0) {
                        CommonProxy.INSTANCE.sendToServer((IMessage)new GetServerPackMessage(need));
                        TextComponentTranslation component = new TextComponentTranslation("message.touhou_little_maid.server.pack_sync", new Object[0]);
                        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)component, false);
                    }
                });
            }
            return null;
        }
    }
}

