/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ApplyChairSkinDataMessage
implements IMessage {
    private UUID entityUuid;
    private ResourceLocation modelId;
    private float mountedHeight;
    private boolean tameableCanRide;
    private boolean noGravity;

    public ApplyChairSkinDataMessage() {
    }

    public ApplyChairSkinDataMessage(UUID entityUuid, ResourceLocation modelId, float mountedHeight, boolean tameableCanRide, boolean noGravity) {
        this.entityUuid = entityUuid;
        this.modelId = modelId;
        this.mountedHeight = mountedHeight;
        this.tameableCanRide = tameableCanRide;
        this.noGravity = noGravity;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUuid = new UUID(buf.readLong(), buf.readLong());
        this.modelId = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.mountedHeight = buf.readFloat();
        this.tameableCanRide = buf.readBoolean();
        this.noGravity = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.entityUuid.getMostSignificantBits());
        buf.writeLong(this.entityUuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modelId.toString());
        buf.writeFloat(this.mountedHeight);
        buf.writeBoolean(this.tameableCanRide);
        buf.writeBoolean(this.noGravity);
    }

    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    public ResourceLocation getModelId() {
        return this.modelId;
    }

    public float getMountedHeight() {
        return this.mountedHeight;
    }

    public boolean isTameableCanRide() {
        return this.tameableCanRide;
    }

    public boolean isNoGravity() {
        return this.noGravity;
    }

    public static class Handler
    implements IMessageHandler<ApplyChairSkinDataMessage, IMessage> {
        public IMessage onMessage(ApplyChairSkinDataMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    boolean canChangeModel;
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.getEntityUuid());
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    boolean bl = canChangeModel = !GeneralConfig.MISC_CONFIG.chairCannotChangeModel || player.func_184812_l_();
                    if (entity instanceof EntityChair) {
                        if (canChangeModel) {
                            EntityChair chair = (EntityChair)entity;
                            chair.setModelId(message.getModelId().toString());
                            chair.setMountedHeight(message.getMountedHeight());
                            chair.setTameableCanRide(message.isTameableCanRide());
                            chair.func_189654_d(message.isNoGravity());
                            if (!message.isTameableCanRide() && chair.func_184179_bs() instanceof EntityMaid) {
                                chair.func_184179_bs().func_184210_p();
                            }
                        } else if (player.func_70089_S()) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.change_model.disabled", new Object[0]));
                        }
                    }
                });
            }
            return null;
        }
    }
}

