/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ChangeMaidTaskMessage
implements IMessage {
    private UUID entityUuid;
    private IMaidTask task;

    public ChangeMaidTaskMessage() {
    }

    public ChangeMaidTaskMessage(UUID entityUuid, IMaidTask task) {
        this.entityUuid = entityUuid;
        this.task = task;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUuid = new UUID(buf.readLong(), buf.readLong());
        ResourceLocation uid = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.task = (IMaidTask)LittleMaidAPI.findTask(uid).or((Object)LittleMaidAPI.getIdleTask());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.entityUuid.getMostSignificantBits());
        buf.writeLong(this.entityUuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.task.getUid().toString());
    }

    public IMaidTask getTask() {
        return this.task;
    }

    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    public static class Handler
    implements IMessageHandler<ChangeMaidTaskMessage, IMessage> {
        public IMessage onMessage(ChangeMaidTaskMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.getEntityUuid());
                    if (entity instanceof EntityMaid && player.equals((Object)((EntityMaid)entity).func_70902_q())) {
                        ((EntityMaid)entity).setTask(message.task);
                    }
                });
            }
            return null;
        }
    }
}

