/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MaidShowHelmetMessage
implements IMessage {
    private UUID uuid;
    private boolean show;

    public MaidShowHelmetMessage() {
    }

    public MaidShowHelmetMessage(UUID uuid, boolean show) {
        this.uuid = uuid;
        this.show = show;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.show = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeBoolean(this.show);
    }

    public static class Handler
    implements IMessageHandler<MaidShowHelmetMessage, IMessage> {
        public IMessage onMessage(MaidShowHelmetMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.uuid);
                    if (entity instanceof EntityMaid && player.equals((Object)((EntityMaid)entity).func_70902_q())) {
                        ((EntityMaid)entity).setShowHelmet(message.show);
                    }
                });
            }
            return null;
        }
    }
}

