/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.client.audio.PortableAudioSound;
import com.github.tartaricacid.touhoulittlemaid.client.audio.music.MusicManger;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPortableAudio;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PortableAudioMessageToClient
implements IMessage {
    private static final String ERROR_404 = "http://music.163.com/404";
    private int entityId;
    private long songId;

    public PortableAudioMessageToClient() {
    }

    public PortableAudioMessageToClient(int entityId, long songId) {
        this.entityId = entityId;
        this.songId = songId;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.songId = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeLong(this.songId);
    }

    public static class Handler
    implements IMessageHandler<PortableAudioMessageToClient, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PortableAudioMessageToClient message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT && GeneralConfig.MUSIC_CONFIG.receiveMusic.booleanValue()) {
                try {
                    String url = MusicManger.NET_EASE_WEB_API.getRedirectMusicUrl(message.songId);
                    if (url == null) {
                        FMLClientHandler.instance().getClient().func_152344_a(() -> Minecraft.func_71410_x().field_71456_v.func_110326_a(I18n.func_135052_a((String)"info.touhou_little_maid.portable_audio.redirect_error", (Object[])new Object[0]), false));
                        return null;
                    }
                    URL realSongUrl = new URL(url);
                    FMLClientHandler.instance().getClient().func_152344_a(() -> {
                        Entity entity = FMLClientHandler.instance().getWorldClient().func_73045_a(message.entityId);
                        if (entity instanceof EntityPortableAudio) {
                            EntityPortableAudio audio = (EntityPortableAudio)entity;
                            if (PortableAudioMessageToClient.ERROR_404.equals(realSongUrl.toString())) {
                                Minecraft.func_71410_x().field_71456_v.func_110326_a(I18n.func_135052_a((String)"info.touhou_little_maid.portable_audio.404", (Object[])new Object[0]), false);
                            } else {
                                PortableAudioSound sound = new PortableAudioSound(audio, realSongUrl);
                                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

