/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.client.audio.music.NetEaseMusicList;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPortableAudio;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PortableAudioMessageToServer
implements IMessage {
    private UUID uuid;
    private List<EntityPortableAudio.MusicListData> musicListData = Lists.newArrayList();
    private int listSize;
    private int index;

    public PortableAudioMessageToServer() {
    }

    public PortableAudioMessageToServer(UUID uuid, NetEaseMusicList.PlayList playList, int index) {
        this.uuid = uuid;
        this.listSize = playList.getTracks().size();
        for (NetEaseMusicList.Track track : playList.getTracks()) {
            this.musicListData.add(new EntityPortableAudio.MusicListData(track.getId(), track.getDurationInTicks()));
        }
        this.index = index;
    }

    private PortableAudioMessageToServer(UUID uuid) {
        this.uuid = uuid;
        this.listSize = 0;
        this.index = -1;
    }

    public static PortableAudioMessageToServer getStopMessage(UUID uuid) {
        return new PortableAudioMessageToServer(uuid);
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.listSize = buf.readInt();
        for (int i = 0; i < this.listSize; ++i) {
            long musicId = buf.readLong();
            int nextTime = buf.readInt();
            this.musicListData.add(new EntityPortableAudio.MusicListData(musicId, nextTime));
        }
        this.index = Math.min(buf.readInt(), this.musicListData.size());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeInt(this.listSize);
        for (EntityPortableAudio.MusicListData data : this.musicListData) {
            buf.writeLong(data.getMusicId());
            buf.writeInt(data.getNextTime());
        }
        buf.writeInt(Math.min(this.index, this.musicListData.size()));
    }

    public static class Handler
    implements IMessageHandler<PortableAudioMessageToServer, IMessage> {
        public IMessage onMessage(PortableAudioMessageToServer message, MessageContext ctx) {
            String playerName;
            if (ctx.side == Side.SERVER && Pattern.matches(GeneralConfig.MUSIC_CONFIG.playerNameReg, playerName = ctx.getServerHandler().field_147369_b.getDisplayNameString())) {
                this.playMusic(message, ctx);
            }
            return null;
        }

        private void playMusic(PortableAudioMessageToServer message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.uuid);
                if (entity instanceof EntityPortableAudio) {
                    EntityPortableAudio audio = (EntityPortableAudio)entity;
                    audio.setPlaying(false);
                    audio.clearAllMusicListData();
                    if (message.index == -1) {
                        return;
                    }
                    audio.setMusicListData(message.musicListData);
                    audio.setMusicIndex(message.index);
                }
            });
        }
    }
}

