/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SendNameTagMessage
implements IMessage {
    private UUID uuid;
    private String name;
    private boolean alwaysShow;

    public SendNameTagMessage() {
    }

    public SendNameTagMessage(UUID uuid, String name, boolean alwaysShow) {
        this.uuid = uuid;
        this.name = name;
        this.alwaysShow = alwaysShow;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.alwaysShow = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeBoolean(this.alwaysShow);
    }

    public static class Handler
    implements IMessageHandler<SendNameTagMessage, IMessage> {
        public IMessage onMessage(SendNameTagMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.uuid);
                    if (entity instanceof EntityMaid) {
                        this.setMaidNameTag(message, player, (EntityMaid)entity);
                    }
                });
            }
            return null;
        }

        private void setMaidNameTag(SendNameTagMessage message, EntityPlayerMP player, EntityMaid maid) {
            String name = message.name.substring(0, Math.min(32, message.name.length()));
            if (player.equals((Object)maid.func_70902_q()) && player.func_184614_ca().func_77973_b() == Items.field_151057_cb) {
                maid.func_96094_a(name);
                maid.func_174805_g(message.alwaysShow);
                maid.func_110163_bv();
                player.func_184614_ca().func_190918_g(1);
            }
        }
    }
}

