/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityScarecrow;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SetScarecrowDataMessage
implements IMessage {
    private UUID entityUuid;
    private String playerName;
    private String text;

    public SetScarecrowDataMessage() {
    }

    public SetScarecrowDataMessage(UUID entityUuid, String playerName, String text) {
        this.entityUuid = entityUuid;
        this.playerName = playerName;
        this.text = text;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUuid = new UUID(buf.readLong(), buf.readLong());
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.entityUuid.getMostSignificantBits());
        buf.writeLong(this.entityUuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    public static class Handler
    implements IMessageHandler<SetScarecrowDataMessage, IMessage> {
        public IMessage onMessage(SetScarecrowDataMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.entityUuid);
                    if (entity instanceof EntityScarecrow) {
                        EntityScarecrow scarecrow = (EntityScarecrow)entity;
                        scarecrow.func_96094_a(message.playerName);
                        scarecrow.setText(message.text);
                    }
                });
            }
            return null;
        }
    }
}

