/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SwitchMaidGuiMessage
implements IMessage {
    private int entityId;
    private int guiId;
    private int formTaskIndex;
    private int startRow;

    public SwitchMaidGuiMessage() {
    }

    public SwitchMaidGuiMessage(int entityId, int guiId, int formTaskIndex) {
        this.entityId = entityId;
        this.guiId = guiId;
        this.formTaskIndex = formTaskIndex;
    }

    public SwitchMaidGuiMessage(int entityId, int guiId, int formTaskIndex, int startRow) {
        this(entityId, guiId, formTaskIndex);
        this.startRow = startRow;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.guiId = buf.readInt();
        this.formTaskIndex = buf.readInt();
        this.startRow = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.guiId);
        buf.writeInt(this.formTaskIndex);
        buf.writeInt(this.startRow);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getGuiId() {
        return this.guiId;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public static class Handler
    implements IMessageHandler<SwitchMaidGuiMessage, IMessage> {
        public IMessage onMessage(SwitchMaidGuiMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    player.openGui((Object)TouhouLittleMaid.INSTANCE, message.getGuiId(), player.func_130014_f_(), message.getEntityId(), message.formTaskIndex, message.getStartRow());
                });
            }
            return null;
        }
    }
}

