/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardEntry;
import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardManger;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SyncCustomSpellCardData
implements IMessage {
    private Map<String, CustomSpellCardEntry> map = Maps.newHashMap();
    private int size;

    public SyncCustomSpellCardData() {
        this.map.clear();
        this.map.putAll(CustomSpellCardManger.CUSTOM_SPELL_CARD_SERVER);
        this.size = this.map.size();
    }

    public void fromBytes(ByteBuf buf) {
        this.map.clear();
        this.size = buf.readInt();
        for (int i = 0; i < this.size; ++i) {
            this.map.put(ByteBufUtils.readUTF8String((ByteBuf)buf), new CustomSpellCardEntry(ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf), null, buf.readInt(), new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)), new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf))));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.size);
        for (String key : this.map.keySet()) {
            CustomSpellCardEntry entry = this.map.get(key);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)key);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getId());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getNameKey());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getDescriptionKey());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getAuthor());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getVersion());
            buf.writeInt(entry.getCooldown());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getIcon().toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getSnapshoot().toString());
        }
    }

    public static class Handler
    implements IMessageHandler<SyncCustomSpellCardData, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SyncCustomSpellCardData message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    CustomSpellCardManger.CUSTOM_SPELL_CARD_CLIENT.clear();
                    CustomSpellCardManger.CUSTOM_SPELL_CARD_CLIENT.putAll(message.map);
                });
            }
            return null;
        }
    }
}

