/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.client.audio.TrolleyAudioSound;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTrolleyAudio;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class TrolleyAudioSoundMessage
implements IMessage {
    private int entityId;
    private String recordId;
    private String recordDisplayName;

    public TrolleyAudioSoundMessage() {
    }

    public TrolleyAudioSoundMessage(String recordDisplayName, ResourceLocation registerName, EntityTrolleyAudio trolleyAudio) {
        this.recordDisplayName = recordDisplayName;
        this.recordId = registerName.toString();
        this.entityId = trolleyAudio.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.recordDisplayName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.recordId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.entityId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.recordDisplayName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.recordId);
        buf.writeInt(this.entityId);
    }

    public String getRecordDisplayName() {
        return this.recordDisplayName;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static class Handler
    implements IMessageHandler<TrolleyAudioSoundMessage, IMessage> {
        public IMessage onMessage(TrolleyAudioSoundMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    Item item;
                    Entity entity = mc.field_71441_e.func_73045_a(message.getEntityId());
                    if (entity instanceof EntityTrolleyAudio && (item = Item.func_111206_d((String)message.getRecordId())) instanceof ItemRecord) {
                        this.apply(message.recordDisplayName, ((ItemRecord)item).func_185075_h(), (EntityTrolleyAudio)entity);
                    }
                });
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void apply(String recordName, SoundEvent event, EntityTrolleyAudio trolleyAudio) {
            TrolleyAudioSound sound = new TrolleyAudioSound(event, trolleyAudio);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            if (StringUtils.isNotBlank((CharSequence)recordName)) {
                Minecraft.func_71410_x().field_71456_v.func_73833_a(I18n.func_135052_a((String)recordName, (Object[])new Object[0]));
            }
        }
    }
}

