/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class WirelessIOGuiMessage
implements IMessage {
    private boolean isInput;
    private boolean isBlacklist;

    public WirelessIOGuiMessage() {
    }

    public WirelessIOGuiMessage(boolean isInput, boolean isBlacklist) {
        this.isInput = isInput;
        this.isBlacklist = isBlacklist;
    }

    public void fromBytes(ByteBuf buf) {
        this.isInput = buf.readBoolean();
        this.isBlacklist = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isInput);
        buf.writeBoolean(this.isBlacklist);
    }

    public static class Handler
    implements IMessageHandler<WirelessIOGuiMessage, IMessage> {
        public IMessage onMessage(WirelessIOGuiMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (stack.func_77973_b() == MaidItems.WIRELESS_IO) {
                        ItemWirelessIO.setIOMode(stack, message.isInput);
                        ItemWirelessIO.setFilterMode(stack, message.isBlacklist);
                    }
                });
            }
            return null;
        }
    }
}

